/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef TRIGMSG_HH
#define TRIGMSG_HH

#include "lmsg/Message.hh"
// #include "lmsg/DataMsg.hh"
#include "TrigProc.hh"
#include "TrigBase.hh"
#include "Segment.hh"

//======================================  Enumerate trigger manager messages
enum {
    tmm_Null= (2<<16),
    tmm_Register,
    tmm_Trigger,
    tmm_Close,
    tmm_ProcID,
    tmm_Ack,
    tmm_NAck,
    tmm_Segment,
    tmm_rmNode,
    tmm_reConfig
};

#define MgrName "Trigger Manager"

template<class T, unsigned int MsgID>
class TrigMgrMsg : public lmsg::Message {
public:
    TrigMgrMsg(void);
    ~TrigMgrMsg(void);
    TrigMgrMsg(const T& ival);
    TrigMgrMsg(lmsg::TransInput& istr);
    void setData(lmsg::TransInput& istr);
    void getData(lmsg::TransOutput& ostr) const;
    const T& refValue(void) const;
    T& refValue(void);
    lmsg::size_type size(void) const;
    lmsg::MsgHeader::MsgType getType(void) const;

private:
    T mValue;
};

//======================================  Trigger manager message classes
//  Message class: TMM_Register
//  Messageid:     tmm_Register
//  Value type:    TrigProc
//  Response type: TMM_ProcID
//  Action:        Register the process defined by the message TrigProc 
//                 structure. The trigger manager returns a process
//                 identifier string to be used in subsequent requests.
// 
typedef TrigMgrMsg<trig::TrigProc, tmm_Register> TMM_Register;
//-----------------------------------------------------------------------
//  Message class: TMM_Trigger
//  Messageid:     tmm_Trigger
//  Value type:    trig::TrigBase
//  Response type: TMM_Ack, TMM_NAck
//  Action:        Add a trigger to be written out. The response is TMM_Ack
//                 if the trigger was added to one or more output streams.
//
typedef TrigMgrMsg<trig::TrigBase, tmm_Trigger>  TMM_Trigger;
//-----------------------------------------------------------------------
//  Message class: TMM_Segment
//  Messageid:     tmm_Segment
//  Value type:    trig::Segment
//  Response type: TMM_Ack, Tmm_NAck
//  Action:        Add a segment to be written out. The response is TMM_Ack
//                 if the segment was added to one or more output streams.
//
typedef TrigMgrMsg<trig::Segment,  tmm_Segment>  TMM_Segment;
//-----------------------------------------------------------------------
//  Message class: TMM_ProcID
//  Messageid:     tmm_ProcID
//  Value type:    string
//  Response type: n/a
//  Action:        None - response from TMM_Register.
//
typedef TrigMgrMsg<std::string,    tmm_ProcID>   TMM_ProcID;
//-----------------------------------------------------------------------
//  Message class: TMM_Close
//  Messageid:     tmm_Close
//  Value type:    string
//  Response type: TMM_Ack, TMM_NAck
//  Action:        Remove the specified process from the trigger manager
//                 process tables.
//
typedef TrigMgrMsg<std::string,    tmm_Close>    TMM_Close;
//-----------------------------------------------------------------------
//  Message class: TMM_RemNode
//  Messageid:     tmm_RemNode
//  Value type:    string
//  Response type: TMM_Ack, TMM_NAck
//  Action:        Remove all processes running on the specified node from
//                 the trigger manager peocess tables.
//
typedef TrigMgrMsg<std::string,    tmm_rmNode>   TMM_RemNode;
//-----------------------------------------------------------------------
//  Message class: TMM_Reconfigure
//  Messageid:     tmm_Reconfigure
//  Value type:    string
//  Response type: n/a
//  Action:        Reconfigure the trigger manager and and its output
//                 streams. The configuration file dpeciecified at start
//                 time is used.
//
typedef TrigMgrMsg<std::string,    tmm_reConfig> TMM_Reconfigure;
//-----------------------------------------------------------------------
//  Message class: TMM_Ack (TMM_NAck)
//  Messageid:     tmm_Ack (tmm_NAck)
//  Value type:    none
//  Response type: n/a
//  Action:        None -  positive (negative) response message.
//
typedef lmsg::HdrOnlyMsg<tmm_Ack>   TMM_Ack;
typedef lmsg::HdrOnlyMsg<tmm_NAck>  TMM_NAck;

#endif  //  TRIGMSG_HH





