/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "MsgWriter.hh"
#include "NameClient.hh"
#include "lmsg/ErrorList.hh"
#include "TrigBase.hh"
#include "Segment.hh"
#include "TrigProc.hh"
#include "TrigMsg.hh"

//----------------------------------
//#include <time.h>
//#include "PConfig.h"
//#include <fstream>
//----------------------------------

using namespace trig;
using namespace lmsg;
using namespace std;

//======================================  Construct and register the client.
MsgWriter::MsgWriter(void) {
}

//======================================  Unregister and go away
MsgWriter::~MsgWriter(void) {
    sendMessage(TMM_Close(refProcess().getProcessID()));
}

//======================================  Register with the trigger manager.
error_type 
MsgWriter::setProcess(const TrigProc& ppp) {
    error_type rc = OK;
    if (!mClient.isOpen()) {
        NameClient nc;
	nc.setDebug(getDebug());
	rc = nc.lookup(MgrName, mTrigManager);
	if (rc) {
	    if (getDebug()) cerr << ppp.getName() 
			     << ": Error finding Trigger Manager, rc= " 
			     << rc << endl;
	    return rc;
	}

	//------------------------------  register this process.
	TMM_ProcID reply;
	rc = mClient.request(mTrigManager, TMM_Register(ppp), reply);
	if (rc) {
	    if (getDebug()) cerr << ppp.getName() 
				 << ": Error registering with TrigMgr, rc= " 
				 << rc << endl;
	    return rc;
	}
	refProcess() = ppp;
	refProcess().setProcessID(reply.refValue());
    }
    return rc;
}

//======================================  Send a segment to the Trigger manager
error_type
MsgWriter::addSegment(const Segment& seg, const TrigProc& ppp) {
    TMM_Segment segmsg(seg);
    segmsg.refValue().setProcess(ppp.getProcessID());
    error_type rc = sendMessage(segmsg);
    if (rc && getDebug()) {
        cerr << ppp.getName() << ": Lost segment message!" << endl;
    }
    return rc;
}

//======================================  Log a trigger
error_type
MsgWriter::addTrigger(const TrigBase& trigger, const TrigProc& ppp) {
    TMM_Trigger trigmsg(trigger);
    trigmsg.refValue().setProcess(ppp.getProcessID());
    error_type rc = sendMessage(trigmsg);
    if (rc && getDebug()) {
        cerr << ppp.getName() << ": Lost Trigger message!" << endl;
    }
    return rc;
}

//======================================  Send message to the Trigger Manager
error_type
MsgWriter::sendMessage(const Message& msg) {
    //----------------------------------  Send the message
    error_type rc = OK;
    MsgHeader reply;
    try {
        rc = mClient.request(mTrigManager, msg, reply, 0, 0);
    } catch (exception& e) {
        cerr << refProcess().getName() 
	     << ": Caught exception in MsgWriter::sendMessage: "
	     << e.what() << endl;
	rc = Invalid;
    }

    //----------------------------------  Check the reply
    if (!rc && reply.getMsgType() != tmm_Ack) {
        rc = Invalid;
    }
    if (rc && getDebug()) {
	cerr << "MsgWriter::sendMessage failed with error: " << rc << endl; 
    }
    return rc;
}

//======================================  Tell TrigMgr to remove processes
error_type
MsgWriter::removeByNode(const string& node) {
    NameClient nc;
    nc.setDebug(getDebug());
    error_type rc = nc.lookup(MgrName, mTrigManager);
    if (rc) {
        if (getDebug()) cerr << refProcess().getName() 
			 << ": Error finding Trigger Manager, rc= " 
			 << rc << endl;
	return rc;
    }

    //----------------------------------  Send the message
    MsgHeader reply;
    TMM_RemNode msg(node);
    try {
        rc = mClient.request(mTrigManager, msg, reply, 0, 0);
    } catch (exception& e) {
        cerr << refProcess().getName() << ": Caught exception in removeByNode: "
	     << e.what() << endl;
	rc = Invalid;
    }

    //----------------------------------  Check the reply
    if (!rc && reply.getMsgType() != tmm_Ack) {
        rc = Invalid;
    }
    return rc;
}

//======================================  Set the debug level.
void 
MsgWriter::setDebug(lmsg::index_type level) {
    mClient.setDebug(level);
}

//======================================  Set the debug level.
lmsg::error_type 
MsgWriter::write(const string& f, const Time& start, const Time& end) const {
    return lmsg::OK;
}
