#include "MonClient.hh"
#include "MonDataMsg.hh"
#include "NameClient.hh"
#include <string>
#include <iostream>
#include "TSeries.hh"
#include "FSeries.hh"
#include "Histogram1.hh"

MonClient::MonClient(void) 
  : mServer(0)
{
    setTimeOut(2.0);
}

MonClient::MonClient(const char* Process) {
    setServer(Process);
    setTimeOut(2.0);
}

MonClient::~MonClient(void) {
}

void
MonClient::setDebug(lmsg::index_type level) {
    lmsg::AppClient::setDebug(level);
}

lmsg::error_type 
MonClient::setServer(const char* server) {
    lmsg::NameClient nc;
    lmsg::error_type rc = nc.lookup(server, mServer);
    if (getDebug()) {
        std::cout << "Set server response = " << rc 
		  << " Address = " << mServer << std::endl;
    }
    return rc;
}

lmsg::error_type 
MonClient::getData(const char* Name, long* ival) {
    MDM_Int reply;
    lmsg::error_type rc = request(mServer, MDM_Request(Name), reply);
    if (rc) return rc;
    *ival = reply.getValue();
    return rc;
}

lmsg::error_type 
MonClient::getData(const char* Name, double* dval) {
    MDM_Double reply;
    lmsg::error_type rc = request(mServer, MDM_Request(Name), reply);
    if (rc) return rc;
    *dval = reply.getValue();
    return rc;
}

lmsg::error_type 
MonClient::getData(const char* Name, std::string* sVal) {
    MDM_String reply;
    lmsg::error_type rc = request(mServer, MDM_Request(Name), reply);
    if (rc) return rc;
    *sVal = reply.getValue();
    return rc;
}

lmsg::error_type 
MonClient::getData(const char* Name, TSeries* ts) {
    MDM_TSeries reply;
    lmsg::error_type rc = request(mServer, MDM_Request(Name), reply);
    if (rc) return rc;
    *ts = reply.getValue();
    return rc;
}

lmsg::error_type 
MonClient::getData(const char* Name, FSeries* fs) {
    MDM_FSeries reply;
    lmsg::error_type rc = request(mServer, MDM_Request(Name), reply);
    if (rc) return rc;
    *fs = reply.getValue();
    return rc;
}

lmsg::error_type 
MonClient::getData(const char* Name, FSpectrum* fs) {
    MDM_FSpectrum reply;
    lmsg::error_type rc = request(mServer, MDM_Request(Name), reply);
    if (rc) return rc;
    *fs = reply.getValue();
    return rc;
}

lmsg::error_type 
MonClient::getData(const char* Name, Histogram1* hg){
    MDM_Histogram1 reply;
    lmsg::error_type rc = request(mServer, MDM_Request(Name), reply);
    if (rc) return rc;
    *hg = reply.getValue();
    return rc;
}

lmsg::error_type 
MonClient::getIndex(std::string& str) {
    MDM_Index reply;
    lmsg::error_type rc = request(mServer, MDM_ReqIndex(), reply);
    if (rc) return rc;
    reply.getIndex(str);
    return rc;
}

