#ifndef glitchMon_HH
#define glitchMon_HH

#include <fstream>
#include <string>
#include <vector>
#include <map>

#include "DatEnv.hh"
#include "TSeries.hh"
#include "Histogram1.hh"
#include "MonServer.hh"
#include "Trend.hh"

//  #include "xsil/Xwriter.hh"
//  #include "xsil/xsil.hh"
#define PIDCVSHDR "$Header: https://redoubt.ligo-wa.caltech.edu/svn/gds/trunk/Monitors/glitchMon/glitchMon.hh 6385 2010-12-10 23:00:42Z john.zweizig@LIGO.ORG $"
#define PIDTITLE "Glitch Monitor"
#include "ProcIdent.hh"
#include "TrigClient.hh"
#include "TrigRslt.hh"
#include "ConfContainer.hh"
#include "MonitorConf.hh"
#include "ConfigInfo.hh"
#include "ChannelInfo.hh"
#include "LockStatus.hh"

/** Glitch Monitor
  * @author Masahiro Ito
  * @version 3.0; Last modified Jun. 13, 2002
  */

	// file name for time series back up
   const char kTSBackUpName[] = "glitchMon_TS_BackUp.xml";

   class glitchMon : public DatEnv, TrigClient
   {
   
   public:
      typedef std::vector<ChannelInfo> ChannelList;
      typedef std::map<std::string, FilterInfo> FilterList;
      typedef std::map<std::string, ThresholdInfo> ThresholdList;
      typedef std::map<std::string, Parameter> ParameterList;
      typedef std::map<std::string, HistogramInfo> HistogramList;
   
   	// monitor data server
      MonServer fMonServ;
   
      /** Initialize glitchMon
      */
      glitchMon(int argc, const char** argv);
   
      /** Destructor for glitchMon
      */
      ~glitchMon();
   
      /** Process one second of data
      */
      void ProcessData();
   
      /** Attention
      */
      void Attention();
   
   private:
   	// list of channel info
      ChannelList fChList;
   
   	// list of filter info
      FilterList fFList;
   
   	// list of threshold info
      ThresholdList fTList;
   
   	// list of event parameter info
      ParameterList fCPList;
   
   	// list of histogram parameters
      HistogramList fHList;
   
   	// monitor parameter
      MonitorConf fMonConf;
   
   	// lock status info
      LockStatus fLock;
   
   	// trend data
      Trend fTrend;
   
   	// list of events in a frame
      EventList fEList;
   
   	// data file
      std::ofstream fDataFile;
   
   	// log file
      std::ofstream fLogFile;
   
   	// monitor start time
      Time fMonStartTime;
   
   	// current log start time
      Time fLogStartTime;
   
      bool fFirstEvent;
   
   	// read config file and set up channels
      bool SetConfig ( std::ifstream& conf );
   
   	// register channels to data access
      void RegisterChannels ();
   
   	// open data&log file
      bool OpenFiles ();
   
   	// close data&log file	
      void CloseFiles ();
   
   	// update data&log file
      void UpdateFiles ();
   
   	// output events to data file & Trig Manager
      void OutputEvents ();
   
   	// handle log file
      void ProcessLog ();
   
   	// output log in html
      void MakeHtmlLog ();
   
   	// output configuration summary in html
      void ConfigLog ();
   
   	// reset data&log file and histogram&time series
      bool Reset ();
   
   	// update histogram&time series periodically
      void UpdateHistogram ();
   
   	//-------------- configuration
   	// void SetDefault ();
   	// set monitor parameters
      bool SetMonitorParam ( const std::string& value );
   
   	// add threshold info
      bool AddThresholdInfo ( const std::string& value );
   
   	// add filter info
      bool AddFilterInfo ( const std::string& value );
   
   	// add event parameter info
      bool AddParameter ( const std::string& value );
   
   	// add histogram info
      bool AddHistogramInfo ( const std::string& value );
   
   	// add channel info
      bool AddChannelInfo ( const std::string& value );
   
   	// get configuration info
      bool GetConfigInfo ( const std::string& value, ConfigInfo& cinfo );
   };

#endif
