/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "DQ_Bit.hh"

using namespace std;

class DQ_Rms : public DQ_bit {
public:
   //===================================  Initialization function.
   DQ_Rms(void) {
   }

   void init(void) {
      cout << "initializing DQ_Rms" << endl;
   }

   //===================================  Process input TSeries, return a flag
   bool bit_value(const tser_vect& data) {
      //--------------------------------  Get argument TSeries and parameters
      TSeries input = data[0];
      Interval avg_time  = numeric_param("avg_time");
      double   threshold = numeric_param("threshold");
      Interval hist_len  = history.getInterval();
      Interval increment = input.getInterval();

      //--------------------------------  Append new (input) data to the history
      if (increment + hist_len > avg_time) {
	 history.eraseStart(hist_len-avg_time);
      }
      if (history.Append(input) != 0) history = input;

      //--------------------------------  Calculate sigma
      TSeries temp = history;
      double average = temp.getAverage();
      double sigma2 = temp*temp / temp.getNSample() - average*average;
      if (sigma2 < 0) sigma2 = 0;

      //--------------------------------  Set flag if sigma > threshold
      return sqrt(sigma2) > threshold;
   }

//====================================  Define local variables
private:
   TSeries history;
};

DQ_PLUGIN(DQ_Rms)
