#ifndef MonitorConf_HH
#define MonitorConf_HH

#include <fstream>
#include <string>
#include <vector>
#include <map>
#include <queue>

#include "Dacc.hh"
#include "Interval.hh"

#include "LockStatus.hh"
#include "ConfContainer.hh"
#include "ChannelInfo.hh"

   class MonitorConf           
   {
   
   public:
      enum SiteType {
      kLHO = 0,
      kLLO = 1
      };
   
      MonitorConf ();   
   
      ~MonitorConf ();
   
      void SetDefault ();
   	
   	const char* GetSiteName () const;
      //-------------- 
   
      /// monitor name
      std::string fName;
   
   	/// Site name (LHO or LLO)
      SiteType fSite;
   
      /// path to the data file.
      std::string fDataPath;
   
   	/// path to the log file.
      //std::string fLogPath;
      bool fDoLog;
   
   	/// time (sec) until stop the monitor.
      Interval fDuration;
   
   	/// time (Sec) to update log file.
      Interval fLogInterval;
   
   	/// flag to enable sending trigger.
      bool fDoTrigger;
   
   	/// trend on/off
      bool fDoTrend;
   
   	/// time series interval (min)
      int fTSInterval;
   };

#endif
