// declaration for class manipulating data for output into a text file
//
// Edward Daw, 8th September 2000
#ifndef Rms_output_HH
#define Rms_output_HH

#include <cstdio>
#include <string>
#include <vector>

class Time;

class Rms_output {
public:
  typedef std::vector<std::string> string_vect;

  Rms_output(const std::string& file_name, int no_of_columns );

  int update_samp_rate(int column, int value );

  int add_header(const std::string& first_header_line,
		 const std::string& second_header_line,
		 int column_number );
  
  int add_data( float value , int column_number );

  int log_error(const char* error_string, const Time& gpstime) const;

  // call this function to disable the printing of text to the file
  void disableTextOutput(void);

  // call this function to enable the printing of text to the file
  void enableTextOutput(void);

  ~Rms_output( );
  int entry_length;
  int total_no_of_columns;
  std::string output_file_name;
  int current_column_number;
  int lines_of_data_written;
  long int gps_time_for_entry;
  std::vector<int> samp_rate_array;
private:

  // flag for whether to actually make text file
  bool _make_text_file;

  // arrays of characters to hold header information
  string_vect header_line_1_set;
  string_vect header_line_2_set;

  // arrays to hold the data
  std::vector<float> data_array;

  // flags set to YES when header is finished.
  int header_finished;

};

#endif // Rms_output_HH
