// this code segment implements the filter class
//
// Edward Daw, 2nd September 2000

#include <stdio.h>
#include "IIRfilter_structures.hh"
#include "IIRfilter.hh"

IIRfilter::IIRfilter( )
{
  filter_name = new char [20];
  sampling_rate = 0;
  no_of_sos_in_filter = 0;
  second_order_sections = NULL;
}

int
IIRfilter::set_name_srate_and_size( int no_of_sections,
				    char* name,
				    int srate)
{
  sprintf(filter_name,"%s",name);
  sampling_rate = srate;
  no_of_sos_in_filter = no_of_sections;
  second_order_sections = new filter_coeffs [ no_of_sos_in_filter ];
  if(second_order_sections == NULL) {
    return -1;
  }
  return 0;
}

int
IIRfilter::put_filter_data( )
{
  printf("Number of Second Order Sections: %d\n",no_of_sos_in_filter);
  printf("Name: %s\n",filter_name);
  printf("Sampling Rate: %d Hz\n",sampling_rate);
  int i;
  for(i=0;i<no_of_sos_in_filter;++i) {
    printf("%f\t%f\t%f\t%f\t%f\n",
	   (second_order_sections+i)->b0,
	   (second_order_sections+i)->b1,
	   (second_order_sections+i)->b2,
	   (second_order_sections+i)->a1,
	   (second_order_sections+i)->a2);
  }
  return 0;
}
	   

int
IIRfilter::set_sos_coeff( double* coeff_set , int section_index )
{
  if( (section_index >= 0) && (section_index < no_of_sos_in_filter) ) {

    (second_order_sections + section_index) -> b0 = coeff_set[0];
    (second_order_sections + section_index) -> b1 = coeff_set[1];
    (second_order_sections + section_index) -> b2 = coeff_set[2];
    (second_order_sections + section_index) -> a1 = coeff_set[3];
    (second_order_sections + section_index) -> a2 = coeff_set[4];
    return 0;
  }
  else {
    return -1;
  }
}

int
IIRfilter::get_b0( int section_index, double* pb0 )
{
  *pb0 = (second_order_sections + section_index)->b0;
  return 0;
}

int
IIRfilter::get_b1( int section_index, double* pb1 )
{
  *pb1 = (second_order_sections + section_index)->b1;
  return 0;
}

int
IIRfilter::get_b2( int section_index, double* pb2 )
{
  *pb2 = (second_order_sections + section_index)->b2;
  return 0;
}

int
IIRfilter::get_a1( int section_index, double* pa1 )
{
  *pa1 = (second_order_sections + section_index)->a1;
  return 0;
}

int
IIRfilter::get_a2( int section_index, double* pa2 )
{
  *pa2 = (second_order_sections + section_index)->a2;
  return 0;
}
  
IIRfilter::~IIRfilter( )
{
  delete [] second_order_sections;
}
