// 
//  Function LLOLHO_Overlap:  Helper function for StochMon.  Calculates
//  overlap reduction function when running on power spectra from
//  different sites.
//  version: TBA (9/10/2004)
//  author: Marc J. Cenac (mjcenac@loyno.edu)
//
////////////////////////////////////////////////////////////////////////////

#include "LLOLHO_Overlap.hh"
#include <cmath>
using namespace std;

void LLOLHO_Overlap(float *gammaPtr, int nsteps, double f_step, double low_freq)
{
  int i = 0; 
  const double Ao = -0.1080266338;
  const double A1 = -3.0364447253;
  const double A2 = 3.4425975344;  
  const double TwoPiT = 0.0629125678;
  double freq = low_freq + (i * f_step);
  double alpha = freq * TwoPiT;
  double Jo = sin(alpha)/alpha;
  double J1 = (sin(alpha)/pow(alpha,2)) - (cos(alpha)/alpha);
  double J2 = (3*sin(alpha)/pow(alpha,3)) - (3*cos(alpha)/pow(alpha,2)) - (sin(alpha)/alpha);
  
  for (int i = 0; i < (nsteps + 1); i++)
    {
      freq = low_freq + (i * f_step);      
      alpha = freq * TwoPiT;
      Jo = sin(alpha)/alpha;
      J1 = (sin(alpha)/pow(alpha,2)) - (cos(alpha)/alpha);
      J2 = (3*sin(alpha)/pow(alpha,3)) - (3*cos(alpha)/pow(alpha,2)) - (sin(alpha)/alpha);
      
      gammaPtr[i] = (Ao * Jo) + (A1 * (J1/alpha)) + (A2 * (J2/pow(alpha,2)));
      
      
    } // end of for (int i = 0; i < (nsteps + 1); i++) loop
  
  
} // end of function

					     
