//
//  Function Integrate: Helper function for StochMon.  Integrates an
//  FSpectrum over all frequencies.  version: 2.8 (Sept 15 2002)
//  author: Marc J. Cenac *inherited from Kevin C. Schlaufman
//  (kcs149@psu.edu)
//     
///////////////////////////////////////////////////////////////////////////
#ifndef Integrate_HH
#define Integrate_HH

#ifndef __CINT__
#include "FSpectrum.hh"
#endif  //------ !def(__CINT__)

/** Helper function for StochMon.  
  * Returns $\int_{f\_low}^{f\_high} df Cal\_PSD(f)$ calculated using Simpson's Rule
  * (if the number of frequency steps in Cal_PSD is even) or the 
  * Trapezoidal Rule (otherwise).
  * @memo Computes stochastic-sensitivity integral.
  * @param Cal_PSD Power spectrum to be integrated.
  * @param f_low Lower frequency of integration (default 0).
  * @param f_high Upper frequency of integration (default 10000).
  */ 
double integrate(FSpectrum const& Cal_PSD, double f_low = 0.0, double f_high = 10000.0);


//  Returns $\int df Cal_PSD(f)$ calculated using Simpson's Rule
//  (if the number of frequency steps in Cal_PSD is even) or the 
//  Trapezoidal Rule (otherwise).
double integrate(FSpectrum const& Cal_PSD, double f_low, double f_high)
{
	//----- Extract the subsection of the PSD to integrate over.
        FSpectrum temp = Cal_PSD.extract(f_low, f_high - f_low);

	//----- Find number of steps and frequency step in temp PSD.
	int nsteps = temp.getNStep();
	float *data = new float[nsteps + 1];
	double coeffecient = temp.getFStep();
	double total = 0.0;

	//----- Copy data from PSD to array data.
	temp.getData(nsteps + 1, data);

        //----- Compute integral.
	if((nsteps % 2) == 0) {
		//----- Apply Simpson's Rule
		total += data[0];
		for(int i = 1; i < nsteps; i++) {
			if((i % 2) == 1)
				total += 4 * data[i];
			else
				total += 2 * data[i];
		}
		total += data[nsteps];
		total *= (coeffecient / 3.0);
	}
	else {
		//----- Apply Trapezoidal Rule
		total += data[0];
		for (int i = 1; i < nsteps; i++)
			total += 2 * data[i];
		total += data[nsteps];
		total *= (coeffecient / 2.0);
	}

	//----- Return sum
        delete[] data;
	return(total);
}

#endif     //  Integrate_HH
