/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//  Function FOM4CumSpectrumWrite:  Helper function for PulsarMon.  Reads an
//  FSpectrum "psd" and copies FOM4: Cumulative Spectrum over Run Period  into a second
//  FSpectrum "out".
//
///////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include <iostream>
#include <fstream>
#include <math.h>

#include "FOM4CumSpectrumWrite.hh"
using namespace std;

void FOM4CumSpectrumWrite(int NStride, FSpectrum& out1, FSpectrum& psd, FSpectrum& out2, FSpectrum& cumsold)
{ 
    //----- Open write and read files
      
    ofstream outdata44;
    outdata44.open("output/FOM4CUMSPEC.txt");
    ofstream outdata55;
    outdata55.open("output/CumS.txt",ios::trunc);//

    //----- Set FSpectrum out equal to FSpectrum psd.
    out1 = psd;
    out2 = cumsold;
    // Cumsold is really the sqrt of cumsold; this is done to deal with 
    // float to double conversion
    //cerr<<"here: time minutes="<<NStride<<endl;
    //----- Initialize items necessary to calculation.
    int nsteps = out1.getNStep();
    float Tst=60.00;// length of one stride in seconds

    float low_freq = out1.getLowFreq();
    float f_step = out1.getFStep();
    float *data = new float[nsteps + 1];
    float *data1 = new float[nsteps + 1];
    double *dataD = new double[nsteps + 1];
    double *CumS= new double[nsteps+1];
    double *CumS2= new double[nsteps+1];
    double *PSD1 = new double[nsteps +1];

    //----- Copy data from out object to data array.
    out1.getData(nsteps + 1, data);
    out2.getData(nsteps + 1, data1);
                             
    for (int i=0; i < (nsteps + 1) ;i++)
	{
	    dataD[i] = (double) data[i];
            CumS[i]= (double) data1[i];
                   
	}
         
   // Here same as normal FOM4 read CumS_Old
  // It should use global var. CumS_Old unless restarted that means NStride == 0 
  // create empty CumS.txt for first time ever
    if (NStride == 0) 
   {
	ifstream indata55;	
	indata55.open("output/CumS.txt",ios::in );
	if (! indata55.is_open() ) 
        {
	    cerr << "Unable to open Cumulative spectrum file." << endl;
	} else 
         {
	    for (int i=0; i < (nsteps + 1) ;i++) 
            {
		indata55>>CumS[i];
	    } 
           indata55.close();
	 }
    }
	

    for (int i = 0; i < (nsteps + 1); i++)
	{
	    double datafreq = low_freq + f_step*i;
	    PSD1[i]=  dataD[i]*dataD[i];
            CumS2[i]=CumS[i]*CumS[i];
	    CumS2[i]=  CumS2[i] + 1/PSD1[i];  
	    data[i] = sqrt(  1/Tst *1/CumS2[i]);
            data1[i]=sqrt(CumS2[i]);
	    outdata44<<datafreq <<" "<<data[i]<<endl;
	    outdata55<<CumS[i]<<endl;

	}
       
        
    //----- Send data back to FSpectrum object.
    out1.setData(nsteps + 1, data);
    out2.setData(nsteps + 1, data1);
       
    outdata44.close();
    outdata55.close();

    delete [] data;
    delete [] data1;
    delete [] PSD1;
    delete [] CumS;
    delete [] dataD;
  	
}

