/* -*- mode: c++; c-basic-offset: 3; -*- */
#ifndef WPIPE_CHANNELCACHE_HH
#define WPIPE_CHANNELCACHE_HH

#include "wtypes.hh"
#include "wframecache.hh"
#include "wreaddata.hh"
#include "Time.hh"
#include <map>
#include <string>
#include <memory>

namespace wpipe {

   /**  channelCache class reads all channels with a common footprint (frameType, 
    *  startTime, endTime in a single fetch.
    */
   class channelCache {
   public:
      channelCache(const wframecache& f, int d);
      ~channelCache(void);
      void fetch(const std::string& type, const Time& start, const Time& stop);
      void request(const str_vect& name, const str_vect& type,
		   const Time& start, const Time& stop, const dble_vect& shift);
      void read(const str_vect& name, const str_vect& type,
		const Time& start, const Time& stop,
		const dble_vect& shift, tser_vect& data);
   private:
      class footprint {
      public:
	 footprint(const std::string& name, const std::string& type,
		   const Time& start, const Time& stop, double shift);
	 footprint(const footprint& x);
	 ~footprint();
	 bool dec(void);
	 bool dataOK(void) const {return _req_count && _ts.get() != 0;}
	 void fetch(const std::string& typ, const Time& strt, const Time& stp);
	 void inc(void) {_req_count++;}
	 std::string key(void) const;
	 const std::string& name(void) const {return _name;}
	 const TSeries& ref_series(void) const {return *_ts;}
	 void set_series(const TSeries& tsz);
	 double shift(void) const {return _shift;}
	 const Time& start(void) const {return _start;}
	 const Time& stop(void) const {return _stop;}
	 const std::string& type(void) const {return _type;}
	 
      private:
	 std::string _name;
	 std::string _type;
	 Time        _start;
	 Time        _stop;
	 double      _shift;
	 std::unique_ptr<TSeries> _ts;
	 int         _req_count;
      };
    
      typedef std::map<std::string, footprint> map_type;
      typedef map_type::const_iterator const_map_iterator;
      typedef map_type::iterator       map_iterator;
    
   private:
      const wframecache&  _frcache;
      map_type            _cache;
      int                 _debugLevel;
   };

} // namespace wpipe

#endif // !defined(WPIPE_CHANNELCACHE_HH)
