/* -*- mode: c++; c-basic-offset: 4; -*- */
/* file LineMonitor.h */

#ifndef LINEMONITOR_HH
#define LINEMONITOR_HH

#include "TrigClient.hh"
#include "DatEnv.hh"
#include "MonServer.hh"
#include "OperStateCondList.hh"
#include "Trend.hh"
#include "TrigPar.hh"
#include "AlarmClient.hh" // for the alarm ;jason
#include "LineTable.hh"

typedef char * pchar;

class ostream;
class LineTable;

namespace xsil {
  class Xwriter;
}

//
//    Data Monitor template class.
//    Class DatTemplate inherits member functions both from
//    Class DatEnv and from Class MonServer
//

class LineMonitor : public DatEnv, MonServer
{
    
public:
    int maxDump;               //  Number of strides the LM should process
    
    LineMonitor(int argc, const char *argv[]);     // Constructor
    ~LineMonitor();                          // Destructor
    
    void ProcessData(void);
    void DumpHelp();
    void Attention(void);                // for Data Viewer
    bool setTrend(const TSeries &, char*);
    TSeries getTrend(LineFilter*, int=1, char='a');
    char *getToken(pchar &, bool = false);
    int getRefIndex(int);
    inline bool isParameter(const char *);
    inline bool getParameter(char *, const char *, int&);
    inline bool getParameter(char *, const char *, double&);
    inline int  getDeep(double, double);    

private:
    
    std::vector<LineFilter *> Filter;       // LineFilter vector 
    std::vector<TSeries *> ts;              // pointers to data
    std::vector<WSeries<double> *> ws;      // pointers to wavelet data
    std::vector<char *> fileName;           // LineMonitor dump file name
    std::vector<char *> freqTag;            // LineFilter frequency tag
    std::vector<char *> channelName;        // array of data channels
    std::vector<double> channelRate;        // decimated data sampling rate 
    std::vector<int>    channelIndex;       // channel index in the channelName array
    std::vector<int>    refFilter;          // reference Filter index
    
    char trendFile[256];
    char indexFile[256];
    char indexHTML[256];
    char filePath[256];
    char htmlFile[256];
    char lockStatus[256];
    char gpsTime[256];
    char suffix[256];
    
    double   frequency;
    double   timeStride;
    bool     dumpLM;
    int      fid;
    int      nT;
    int      nDump;
    int      mDump;      
    int      dmtDump;
    int      nFirst;
    int      nLast;
    int      nSkip;
    double   masterRate;
    int      nBand;
    double   fScan;
    double   SNR;
    double   fBand;
    int      nScan;      
    int      nBuffer;                   // lengths of buffer to serve trend data to data viewer
    
    Time  currentTime;
    Time  frameStart;
    Trend mTrend;
    OperStateCondList mOSC;
    TrigPar  mDict;
    int appendMode;
    pchar pString;
    
    std::vector<TSeries*> amplitude_tseries;
    std::vector<TSeries*> phase_tseries;
    std::vector<TSeries*> frequency_tseries;
    std::vector<char   *> amplitude_name;
    std::vector<char   *> frequency_name;
    std::vector<char   *> phase_name;

    bool dmtviewer_tseries_allocated;

    char a_namea[200];
    AlarmClient al_ca;
    AlarmHandle al_ha;
    AlarmClient al_cb;
    AlarmHandle al_hb;
    bool plow[2];               // plow[0] for al_a , plow[1] for al_b ; true if snr exists
    bool al_set[2];
    std::vector<alarmEntry *> al_E;  // Jason alarmEntry is described in LineTable.hh
    void mktag(const char *);      // allows one to put tags as |-| in DumpHtml
    LineTable* lmonTable;
    int debug;
    int ifolock;
};

inline bool LineMonitor::isParameter(const char *s){
  int n = strlen(s);
  bool isP = (n>0) ? true : false;
  for(int i=0; i<n; i++)
    if(!isdigit(s[i]) && s[i] != '-' && s[i] != '.')
      isP = false;
  return isP;
}

inline bool LineMonitor::getParameter(char *w, const char *c, int &x){
  if ( strcmp(w,c) == 0 ){
    if( isParameter(w = getToken(pString)) )
      sscanf(w,"%d",&x);
    return true;
  }
  return false;
}

inline bool LineMonitor::getParameter(char *w, const char *c, double &x){
  if ( strcmp(w,c) == 0 ){
    if( isParameter(w = getToken(pString)) )
      sscanf(w,"%lf",&x);
    return true;
  }
  return false;
}

inline int LineMonitor::getDeep(double f1, double f2){
  if(f1<=0. || f2<=0. || f1==f2) return 0;

  int n=0;
  while(int(f1/f2+0.01)>1){ f1*=0.5; n+=1; }
  while(int(f2/f1+0.01)>1){ f2*=0.5; n-=1; }
  return n;
}

#endif     //  LINEMONITOR_HH












