#include <iostream>
#include <fstream>

  /* F2C prototypes */

#ifndef F2C_INCLUDE
#define F2C_INCLUDE

typedef long int integer;
typedef char *address;
typedef short int shortint;
typedef float sreal;
typedef double doublereal;
typedef struct { sreal r, i; } complx;
typedef struct { doublereal r, i; } doublecomplx;
typedef long int logical;
typedef short int shortlogical;
typedef char logical1;
typedef char integer1;
typedef short ftnlen;

/* typedef long long longint; */ /* system-dependent */

#define TRUE_ (1)
#define FALSE_ (0)


/* I/O stuff */

//  Note: The following conflicts with the standard library...
//
// #define abs(x) ((x) >= 0 ? (x) : -(x))
// #define dabs(x) (doublereal)abs(x)
// #define min(a,b) ((a) <= (b) ? (a) : (b))
// #define max(a,b) ((a) >= (b) ? (a) : (b))
// #define dmin(a,b) (doublereal)min(a,b)
// #define dmax(a,b) (doublereal)max(a,b)
//
// Replacement code
//        I have changed all occurrances of dabs to fabs in the source
//        and provide the following inline functions.
inline doublereal dmin(doublereal a, doublereal b) {return a<=b ? a : b;}
inline doublereal dmax(doublereal a, doublereal b) {return a>=b ? a : b;}
inline integer min(integer a, integer b) {return a<=b ? a : b;}
inline integer max(integer a, integer b) {return a>=b ? a : b;}

/* procedure parameter types for -A and -C++ */

#define F2C_proc_par_types 1
#ifdef __cplusplus
typedef int /* Unknown procedure type */ (*U_fp)(...);
typedef shortint (*J_fp)(...);
typedef integer (*I_fp)(...);
typedef sreal (*R_fp)(...);
typedef doublereal (*D_fp)(...), (*E_fp)(...);
typedef /* Complex */ void (*C_fp)(...);
typedef /* Double Complex */ void (*Z_fp)(...);
typedef logical (*L_fp)(...);
typedef shortlogical (*K_fp)(...);
typedef /* Character */ void (*H_fp)(...);
typedef /* Subroutine */ int (*S_fp)(...);
#else
typedef int /* Unknown procedure type */ (*U_fp)();
typedef shortint (*J_fp)();
typedef integer (*I_fp)();
typedef sreal (*R_fp)();
typedef doublereal (*D_fp)(), (*E_fp)();
typedef /* Complex */ void (*C_fp)();
typedef /* Double Complex */ void (*Z_fp)();
typedef logical (*L_fp)();
typedef shortlogical (*K_fp)();
typedef /* Character */ void (*H_fp)();
typedef /* Subroutine */ int (*S_fp)();
#endif
/* E_fp is for real functions when -R is not specified */
typedef void C_f;	/* complex function */
typedef void H_f;	/* character function */
typedef void Z_f;	/* double complex function */
typedef doublereal E_f;	/* real function with -R not specified */

/* undef any lower-case symbols that your C compiler predefines, e.g.: */

#ifndef Skip_f2c_Undefs
#undef cray
#undef gcos
#undef mc68010
#undef mc68020
#undef mips
#undef pdp11
#undef sgi
#undef sparc
#undef sun
#undef sun2
#undef sun3
#undef sun4
#undef u370
#undef u3b
#undef u3b2
#undef u3b5
#undef unix
#undef vax
#endif
#endif

/* addition definitions needed for C++ included in clapack as f2ch.add */
/* If you are using a C++ compiler, append the following to f2c.h
   for compiling libF77 and libI77. */

#ifdef __cplusplus
extern "C" {
  double c_abs(complx *z);
  void c_div(complx *, complx *, complx *);
  double f__cabs(double sreal, double imag);
  double r_imag(complx *z);
  void r_cnjg(complx *r, complx *z);
  integer s_cmp(const char *, const char *, ftnlen,ftnlen);
  void s_copy(char *, const char *, ftnlen, ftnlen);
}
#endif

extern "C" {

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <limits.h>
#include <time.h>
#include <stdarg.h>   
#include "signal.h"

  int chan_clean(int,int,float,float *,float *,float *,int,float **,float **,
		 float *,float *, complx *,complx *,float,complx *,complx *,
		 integer,integer *);
  int calc_rho(int,int,float,float *,float *,int,float **,float **,float *,
	       complx *,complx *,float *);
  void read_binary_fft(char *fname, unsigned int length, float *rp_fft,
		       float *ip_fft, float *delta_f);
  void write_binary_fft(char *filename, int length, float *rp_fft,
			float *ip_fft, float delta_f);
  void write_fft(char *fname, int length, float *rp_fft, float *ip_fft, 
		 float delta_f);
  void write_rho2(std::ofstream &ofs, float freq, float rho2, int nenv_chan,
		  float *rho2_pairwise);
  void fopen_check(FILE *fp, char *fname);
  void ifsopen_check(std::ifstream &fs,const char *); 

  /* CLAPACK prototypes */
  int cher_(char *, integer *, sreal *, complx *, 
	    integer *, complx *, integer *); 
  int chesv_(char *uplo, integer *n, integer *nrhs, complx *a,
	     integer *lda, integer *ipiv, complx *b, integer *ldb, complx *work,
	     integer *lwork, integer *info);
  int chetf2_(char *uplo, integer *n, complx *a, integer *lda,
	      integer *ipiv, integer *info);
  int chetrf_(char *uplo, integer *n, complx *a, integer *lda,
	      integer *ipiv, complx *work, integer *lwork, integer *info);
  int chetrs_(char *uplo, integer *n, integer *nrhs, complx *a, integer *lda, 
	      integer *ipiv, complx *b, integer *ldb, integer *info);
  int clacgv_(integer *n, complx *x, integer *incx);
  int claev2_(complx *a, complx *b, complx *c, sreal *rt1, 
	      sreal *rt2, sreal *cs1, complx *sn1);
  int clahef_(char *uplo, integer *n, integer *nb, integer *kb, complx *a, 
	      integer *lda, integer *ipiv, complx *w, integer *ldw, 
	      integer *info);
  int crot_(integer *n, complx *cx, integer *incx, complx *cy, 
	    integer *incy, sreal *c, complx *s);
  int slaev2_(sreal *, sreal *, sreal *, sreal *, sreal *, sreal *, sreal *);
  integer ilaenv_(integer *, const char *, const char *, integer *, integer *, 
		  integer *, integer *, ftnlen, ftnlen);

  /* BLAS prototypes */
int cgemm_(const char *, const char *, integer *, integer *, 
	    integer *, complx *, complx *, integer *, complx *, integer *, 
	    complx *, complx *, integer *);
logical lsame_(const char *, const char *);
int cgemv_(const char *, integer *, integer *, complx *
	    , complx *, integer *, complx *, integer *, complx *, complx *, integer *);
int cher_(char *, integer *, sreal *, complx *, 
		integer *, complx *, integer *);
int ccopy_(integer *, complx *, integer *, 
	    complx *, integer *);
integer icamax_(integer *, complx *, integer *);
int csscal_(integer *, sreal *, complx *, integer *);
int cgeru_(integer *, integer *, complx *, 
				  complx *, integer *, complx *, integer *, complx *, integer *);
int cswap_(integer *, complx *, integer *, complx *, integer *);   
int xerbla_(const char *,  integer *);






}
