#ifndef SEG_STACK_HH
#define SEG_STACK_HH

#include "calc_engine/eval_stack.hh"
#include "SegList.hh"
#include <string>
#include <vector>

class seg_token : public eval_token {
public:
    /**  Data types. For now the only data types are string, numeric and 
      *  logical (boolean values). In the future this should be templated 
      *  to a more descriptive class.
      */
    enum type_enum {
      kNone,
      kSegment,
      kNumeric
    };
    using eval_token::datype;

public:
    //----------------------------------  Constructors
    seg_token(void);
    seg_token(const LockSegList& s);
    seg_token(double d);
    virtual ~seg_token(void);

    //----------------------------------  eval_type virtual functions.
    seg_token* clone(void) const;
    datype getType(void) const;
    double getNumeric(void) const;
    std::string getString(void) const;
    void setNumeric(double val);
    void setString(const std::string& s);

    //---------------------------------- Specialized mutators/accessors.
    LockSegList& refSegment(void);
    const LockSegList& refSegment(void) const;

private:
    LockSegList mValue;
    double      mNumeric;
    type_enum   mType;
};

//====================================== inline functions
inline const LockSegList& 
seg_token::refSegment(void) const {
    return mValue;
}

inline LockSegList& 
seg_token::refSegment(void) {
    return mValue;
}

/**  The evaluation stack holds currently active intermediate results.
  *  In the initial implementation, data are stored as strings.
  *  @memo Evaluation stack.
  *  @author John Zweizig
  *  @version 1.0; Last modified July 6, 2004
  */
class seg_stack : public eval_stack {
public:
    using eval_stack::push;

    /**  Evaluation stack constructor.
      */
    seg_stack(void);

    /** Evaluation stacke destructor. 
      */
    ~seg_stack(void) {}

    /** Dump stack contents.
      */
    void dump(std::ostream& out) const;

    /** perform an operation on the top stack entries.
     */
    void evaluate(OpsEnum op);

    /**  Test whether stack entry is numeric.
     */
    bool numeric(int lvl) const;

    /** Push a string on the top of the stack.
     */
    void push(const std::string& str);

    /**  Push a numeric value. The double precision float value is converted
      *  to a string before being pushed on to the stack.
      */
    void push(double val);
};

inline bool 
seg_stack::numeric(int off) const {
    return type(off) == seg_token::kNumeric;
}

#endif // !defined(STR_STACK_HH)
