#include "xsil/xsil.hh"
#include "xsil/array.hh"
#include "xsil/comment.hh"
#include "xsil/param.hh"
#include "xsil/table.hh"
#include "xsil/xsil_time.hh"
#include "xsil/Xwriter.hh"

using namespace xsil;
using namespace std;

//======================================  Default constructor.
XSIL::XSIL(void) {}


//======================================  Data constructor.
XSIL::XSIL(const char* Name, const char* Type) 
  : xobj(Name, Type) {
}

//======================================  Default destructor.
XSIL::XSIL(const XSIL& x) 
  : xobj(x) {
    for (const_objlist_iterator i=x.mList.begin() ; i!=x.mList.end() ; i++) {
        mList.push_back((*i)->Clone());
    }
}

//======================================  Default destructor.
XSIL::~XSIL(void) {
    for (objlist_iterator it = mList.begin() ; it != mList.end() ; it++) {
        delete *it;
    }
    mList.erase(mList.begin(), mList.end());
}

//======================================  Default destructor.
XSIL*
XSIL::Clone(void) const {
    return new XSIL(*this);
}

//======================================  Spew the entire kit and kaboodle
void 
XSIL::Spew(Xwriter& xout) const {
    const int   nattr=2;
    const char* attnames[]={"Name","Type"};
    const char* attstrings[]={getName(), getType()};
    xout.Tag(getObjType(), nattr, attnames, attstrings);
    xout.endLine();
    for (const_objlist_iterator it=mList.begin() ; it != mList.end() ; it++) {
        (*it)->Spew(xout);
    }
    xout.endTag(getObjType());
}

//======================================  Add an array object
xobj*
XSIL::addObject(const xobj& x) {
    return addObject(x.Clone());
}

//======================================  Add an array object
xobj*
XSIL::addObject(xobj* x) {
    mList.push_back(x);
    return x;
}

//======================================  Add an array object
XSIL*
XSIL::addXSIL(const char* Name, const char* Type) {
    return (XSIL*) addObject(new XSIL(Name, Type));
}

//======================================  Add an array object
xsil::array*
XSIL::addArray(const char* Name, const char* Type, const char* Unit) {
    return (array*) addObject(new array(Name, Type, Unit));
}

//======================================  Add a comment object
comment* 
XSIL::addComment(const char* Text) {
    return (comment*) addObject(new comment(Text));
}

//======================================  Add a param object
param*
XSIL::addParam(const char* Name, const char* Unit, double Value) {
    return (param*) addObject(new param(Name, Unit, Value));
}

//======================================  Add a param object
param*
XSIL::addParam(const char* Name, const char* Unit, int Value) {
    return (param*) addObject(new param(Name, Unit, Value));
}

//======================================  Add a param object
param*
XSIL::addParam(const char* Name, const char* Type, const char* Unit,
		     const char* Value) {
    return (param*) addObject(new param(Name, Type, Unit, Value));
}

//======================================  Add a table object
table*
XSIL::addTable(const char* Name, const char* Type) {
    return (table*) addObject(new table(Name, Type));
}

//======================================  Add an xsil_time object
xsil::xsil_time*
XSIL::addTime(const char* Name, const char* Type, const char* Value) {
    return (xsil_time*) addObject(new xsil_time(Name, Type, Value));
}

//======================================  Add a xsil_time object
xsil::xsil_time*
XSIL::addTime(const char* Name, const Time & t) {
    return (xsil_time*) addObject(new xsil_time(Name, t));
}

//======================================  Get the type
bool
XSIL::container(void) const {
    return true;
}

//======================================  Get the type
const char* 
XSIL::getObjType(void) const {
    return "XSIL";
}

//======================================  Erase a specified object
void 
XSIL::erase(const xobj* x) {
    for (objlist_iterator it=mList.begin() ; it != mList.end() ; it++) {
        if (*it == x){
	    mList.erase(it);
	    return;
	}
    }
}

//======================================  Find a specified object
const xobj* 
XSIL::find(const string& name, const string& type) const {
    for (const_objlist_iterator it=mList.begin() ; it != mList.end() ; it++) {
        if (name.empty() || (*it)->refName() == name) {
	    if (type.empty() || type == (*it)->getObjType()) return (*it);
	}
    }
    return 0;
}

//======================================  Find a specified object
xobj*
XSIL::find(const string& name, const string& type) {
    for (objlist_iterator it=mList.begin() ; it != mList.end() ; it++) {
        if (name.empty() || name == (*it)->refName()) {
	    if (type.empty() || type == (*it)->getObjType()) return (*it);
	}
    }
    return 0;
}

//======================================  Find a specified object
const xobj* 
XSIL::findr(const string& name, const string& type) const {
    for (const_objlist_iterator it=mList.begin() ; it != mList.end() ; it++) {
        if (name.empty() || (*it)->refName() == name) {
	    if (type.empty() || type == (*it)->getObjType()) return (*it);
	} else if ((*it)->container()) {
	    const xobj* p = (*it)->findr(name, type);
	    if (p) return p;
	}
    }
    return 0;
}

//======================================  Find a specified object
xobj* 
XSIL::findr(const string& name, const string& type) {
    for (const_objlist_iterator it=mList.begin() ; it != mList.end() ; it++) {
        if (name.empty() || (*it)->refName() == name) {
	    if (type.empty() || type == (*it)->getObjType()) return (*it);
	} else if ((*it)->container()) {
	    xobj* p = (*it)->findr(name, type);
	    if (p) return p;
	}
    }
    return 0;
}
