/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "xsil/genXml.hh"
#include "xsil/genText.hh"
#include "xsil/Xwriter.hh"

using namespace xsil;
using namespace std;

//======================================  default constructor
genXml::genXml(void) {
}

//======================================  data constructor
genXml::genXml(const char* objty, const attr_list& al)
   : mObjType(objty), mObjAttr(al)
{
   const_attr_iter p = al.find("Name");
   if (p != al.end()) setName(p->second.c_str());
   p = al.find("Type");
   if (p != al.end()) setType(p->second.c_str());
}

//======================================  Copy constructor
genXml::genXml(const genXml& x)
   : xobj(x.getName(), x.getType())
{
   mObjType = x.mObjType;
   mObjAttr = x.mObjAttr;
   mObjList.reserve(x.mObjList.size());
   for (size_t i=0; i<x.mObjList.size(); i++) addObject(*mObjList[i]);
}

//======================================  default destructor
genXml::~genXml(void) {
   size_t N = mObjList.size();
   for (size_t i=0; i<N; i++) delete mObjList[i];
}

//======================================  write it out
void
genXml::Spew(xsil::Xwriter& ostr) const {
   size_t M = mObjAttr.size();
   vector<const char*> attr, value;
   attr.reserve(M);
   value.reserve(M);
   for (const_attr_iter i=mObjAttr.begin(); i != mObjAttr.end(); i++) {
      attr.push_back(i->first.c_str());
      value.push_back(i->second.c_str());
   }
   ostr.Tag(mObjType.c_str(), M, &attr[0], &value[0]);
   size_t N = mObjList.size();
   for (size_t i=0; i<N; i++) mObjList[i]->Spew(ostr);
   ostr.endTag(mObjType.c_str());
}

//======================================  Add an object to the end of the list
xobj*
genXml::addObject(const xobj& object) {
   return addObject(object.Clone());
}
   
//======================================  Add an object to the end of the list
xobj* 
genXml::addObject(xobj* object) {
   mObjList.push_back(object);
   return object;
}

//======================================  Add a text string to the list
genText* 
genXml::addString(const std::string& text) {
   if (mObjList.empty() || string(mObjList.back()->getObjType()) != "genText") {
      addObject(genText(text));
   } else {
      dynamic_cast<genText*>(mObjList.back())->addString(text);
   }
   return dynamic_cast<genText*>(mObjList.back());
}
	
//=========================================  Clone a genXml.
genXml*
genXml::Clone(void) const {
   return new genXml(*this);
}

//=========================================  Find a named object
const xobj*
genXml::find(const std::string& nm, const std::string& ty) const {
   size_t N = mObjList.size();
   for (size_t i=0; i<N; i++) {
      if (mObjList[i]->refName() != nm) continue;
      if (!ty.empty() && mObjList[i]->refType() != ty) continue;
      return mObjList[i];
   }
   return 0;
}

//=========================================  Find a named object
xobj*
genXml::find(const std::string& nm, const std::string& ty) {
   size_t N = mObjList.size();
   for (size_t i=0; i<N; i++) {
      if (mObjList[i]->refName() != nm) continue;
      if (!ty.empty() && mObjList[i]->refType() != ty) continue;
      return mObjList[i];
   }
   return 0;
}
 

//=========================================  Find a named object
const xobj*
genXml::findr(const std::string& nm, const std::string& ty) const {
   size_t N = mObjList.size();
   for (size_t i=N; i; i--) {
      if (mObjList[i-1]->refName() != nm) continue;
      if (!ty.empty() && mObjList[i-1]->refType() != ty) continue;
      return mObjList[i-1];
   }
   return 0;
}

//=========================================  Find a named object
xobj*
genXml::findr(const std::string& nm, const std::string& ty) {
   size_t N = mObjList.size();
   for (size_t i=0; i; i--) {
      if (mObjList[i-1]->refName() != nm) continue;
      if (!ty.empty() && mObjList[i-1]->refType() != ty) continue;
      return mObjList[i-1];
   }
   return 0;
}
 
