#include "xsil/dim.hh"
#include "xsil/Xwriter.hh"

//--------------------------------------  Constructor
xsil::dim::dim(void) {
}

//--------------------------------------  Data Constructor
xsil::dim::dim(const char* Name, int N) 
  : xobj(Name) {
    mDim = N;
}

//--------------------------------------  Destructor
xsil::dim::~dim(void) {}

//--------------------------------------  Print out Dimension
void 
xsil::dim::Spew(Xwriter& xout) const {
    const char* atnames[]   = {"Name"};
    const char* atstrings[] = {getName()};
    xout.Tag(getObjType(), 1, atnames, atstrings);
    xout.Integer(getDim());
    xout.endTag(getObjType());
}

//--------------------------------------  Clone an object
xsil::dim* 
xsil::dim::Clone(void) const {
    return new dim(*this);
}

//--------------------------------------  Get object type
const char* 
xsil::dim::getObjType(void) const {
    return "Dim";
}

//--------------------------------------  Get dimension value
int  
xsil::dim::getDim(void) const {
    return mDim;
}

//--------------------------------------  set dimension value.
void 
xsil::dim::setDim(int Dim) {
    mDim = Dim;
}
