/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef XSIL_COMMENT_HH
#define XSIL_COMMENT_HH

#include "xsil/xobj.hh"
#include <string>

namespace xsil {
    class Xwriter;

/**  XSIL comment field definition.
  *  @memo XSIL comment field.
  *  @author J. Zweizig
  *  @version 1.1; Modified December 13, 1999
  *  @ingroup IO_xsil
  */
class comment : public xobj {
public:
    /**  Default constructer.
      *  @memo Default constructor.
      */
    comment(void);

    /**  Comment constructer.
      *  @memo Comment constructor.
      *  @param Text Comment text pointer.
      */
    comment(const char* Text);

    /**  Destructer.
      *  @memo Destructor.
      */
    ~comment(void);

    /**  Write the Comment to an XML file.
      *  @memo write Comment to an XML file.
      *  @param xout XSIL writer to receive the comment definition.
      */
    void Spew(Xwriter& xout) const;

    /**  Clone a comment block.
      *  @memo Clone the comment object.
      *  @return Pointer to the cloned object.
      */
    comment* Clone(void) const;

    /**  Get the comment text.
      *  @memo get the comment text.
      *  @return Pointer to the comment text.
      */
    const char* getText(void) const;

    /**  Get the object type.
      *  @memo Get the object type.
      *  @return Pointer to the type string.
      */
    const char* getObjType(void) const;

    /**  Set the comment text.
      *  @memo Set the object text.
      *  @param Text Pointer to the text string.
      */
    void setText(const char* Text);

private:
    std::string mText;
};

}

#endif // XSIL_COMMENT_HH
