#include "xsil/comment.hh"
#include "xsil/Xwriter.hh"

//--------------------------------------  Default constructor
xsil::comment::comment(void) {
}

//--------------------------------------  Data constructor
xsil::comment::comment(const char* Text) {
    setText(Text);
}

//--------------------------------------  Destructor
xsil::comment::~comment(void) {
}

//--------------------------------------  Output
void
xsil::comment::Spew(Xwriter& xout) const {
    xout.Tag(getObjType());
    xout.text(mText);
    xout.endTag(getObjType());
}

//--------------------------------------  Get Object type
xsil::comment* 
xsil::comment::Clone(void) const {
    return new comment(getText());
}

//--------------------------------------  Get Object type
const char* 
xsil::comment::getObjType(void) const {
    return "Comment";
}

//--------------------------------------  Get comment
const char* 
xsil::comment::getText(void) const {
    return mText.c_str();
}

//--------------------------------------  Set comment
void 
xsil::comment::setText(const char* Text) {
    if (Text) mText = Text;
}
