#include "lsmp.hh"
#include <iostream>

using namespace std;

int 
main(int argc, const char* argv[]) {
    if (argc > 1 && string(argv[1]) == "-l") {
        cout << "Valid parameter names are: " << endl;
        cout << "  exists     1 if partition exists." << endl;
	cout << "  name       Partition name." << endl;
	cout << "  shmid      Shm identifier." << endl;
	cout << "  version    Lsmp version number." << endl;
	cout << "  nbuf       Number of partition buffers." << endl;
	cout << "  lbuf       Length of partition buffers." << endl;
	cout << "  ncons      Number of active consumers." << endl;
	cout << "  use_count  Number of processes using the partition." <<endl;
	cout << "  buffer_tot Total buffers written to partition." << endl;
	cout << "  maxcons    Number of consumer slots." << endl;
	cout << "  semglobal  Global semaphore cluster ID." << endl;
	cout << "  fullbuf    Number of buffers in the full queue." << endl;
	cout << "  freebuf    Number of buffers in the free queue." << endl;
	cout << "  usedbuf    Sum of buffer use counts." << endl;
	cout << "  last_ID    ID of Last buffer in the full queue." << endl;
	cout << "  vstart     Virtual start of data" << endl;
	return 0;
    } else if (argc < 3) {
        cerr << "Command syntax: smstat [-l] <par1> [... <parN>] <partition>"
	     << endl;
        return 1;
    }
    LSMP_ACCESS sm(argv[argc-1]);
    if (sm.valid()) {
        for (int i=1 ; i<argc-1 ; i++) {
	    cout << sm.getStat(argv[i]) << endl;
	}
    } else if (string(argv[1]) == "exists") {
        cout << "0" << endl;
    } else {
        cerr << "smstat: Unable to open partition " << argv[argc-1] 
	     << ": " << sm.Error() << endl;
	return 1;
    }
    return 0;
}
