#include "lmsg/Buffer.hh"
#include "lmsg/BufferPool.hh"
#include <iostream>

lmsg::BufferPool 
defaultLMsgBufferPool(DEFAULTBUFFERPOOLCOUNT, DEFAULTBUFFERPOOLSIZE);

lmsg::BufferPool::~BufferPool(void) {
    thread::semlock lockit (mMux);
    size_type rcount=0;
    while (mPool.begin() != mPool.end()) {
        delete mPool.front();
	mPool.pop_front();
	rcount++;
    }
    if (rcount != mCount) {
        std::cerr << "Number of buffers released (" << rcount 
		  << ") is not equal to the number of buffers (" << mCount 
		  << ")." << std::endl;
    }
}

lmsg::BufferPool::BufferPool(size_type number, size_type length) {
    mLength = length;
    mCount  = 0;
    for (size_type i=0 ; i<number ; i++) {
        Buffer* buf = new Buffer(mLength);
        if (buf) {
	    buf->setPool(*this);
	    returnBuffer(buf);
	    mCount++;
	}
    }
}

lmsg::Buffer* 
lmsg::BufferPool::getBuffer(void) {
    thread::semlock lockit (mMux);
    if (mPool.empty()) return 0;
    Buffer* buf = mPool.front();
    mPool.pop_front();
    return buf;
}

void 
lmsg::BufferPool::returnBuffer(Buffer* buff) {
    thread::semlock lockit (mMux);
    if (buff) mPool.push_back(buff);
}

lmsg::size_type
lmsg::BufferPool::getDataLength(void) const {
    if (mLength < sizeof(MsgHeader)) return 0;
    return mLength-sizeof(MsgHeader);
}

