#include "html/genAttr.hh"
#include "html/link.hh"
#include "html/text.hh"
#include "html/writer.hh"

namespace html {

//======================================  Default constructor
link::link(void) {}

//======================================  Data constructor
link::link(const std::string& txt, const std::string& addr) {
    setText(txt);
    if (!addr.empty()) addAttr("href", genAttr(addr));
}

//======================================  Destructor
link::~link(void) {
}

//======================================  tag string
const char* 
link::getTag(void) const {
    return "a";
}

//======================================  Clone a link
link*
link::clone(void) const {
    return new link(*this);
}

//======================================  Set the link description
void 
link::setText(const std::string& txt) {
    addObject(text(txt));
}

//======================================  Set the link target address
void 
link::setAddr(const std::string& addr) {
    addAttr("href", genAttr(addr));
}

}
