#include "html/image.hh"
#include "html/genAttr.hh"
#include "html/writer.hh"

using namespace html;
static const char* imgTag = "img";

//======================================  Default constructor
image::image(void) {
}

//======================================  Data constructor
image::image(const std::string& src) {
    setSource(src);
}

//======================================  Destructor
image::~image(void) {
}

//======================================  Clone an image
image*
image::clone(void) const {
    return new image(*this);
}

//======================================  Write the image.
void 
image::write(writer& out) const {
    if (!mAttr.empty()) out.tagNData(imgTag, mAttr);
}

//======================================  Set the image width
void 
image::setWidth(const std::string& w) {
    mAttr.repAttr("width", genAttr(w));
}

//======================================  Set the image source file
void 
image::setSource(const std::string& src) {
    mAttr.repAttr("src", genAttr(src));
}
