//
// $Id: StdAbove.hh 6619 2012-03-12 23:58:12Z john.zweizig@LIGO.ORG $
//
// Author: David Chin <dwchin@umich.edu>
//
//         2477 Randall Lab, Univ. of Michigan
//         500 E. University Ave.
//         Ann Arbor, MI 48109
//         +1-734-764-5146
//         +1-734-730-1274
//
// Written based on idea by K. Riles <kriles@umich.edu>

#ifndef OSCSTDABOVE_HH
#define OSCSTDABOVE_HH

#include "osc/OperStateCond.hh"
#include "FSeries.hh"
#include "FSpectrum.hh"


namespace osc
{
    //
    // STDABOVE
    //
    class StdAbove
        : public OperStateCond
    {
    public:
        StdAbove(DaccAPI          *access,
                 std::ostream        *outstream,
                 std::string     chanName,  // name of assoc. channel
                 osc::IntParMap &intparams,
                 osc::DblParMap &dblparams,
                 int debug = 0);

        virtual ~StdAbove() {};

        virtual bool satisfied();

    private:
        /** {\tt StdAbove} has one parameter.  This OSC is
         * satisfied if the STD of the time series data is greater
         * than the {\tt threshold}
         * \begin{enumerate}
         *    \item {\bf {\tt threshold}} STD threshold
         * \end{enumerate}
         */
    };

} // namespace osc

#endif // !defined OSCSTDABOVE_HH
