//    Plot the power spectrum of the time integral of an FSeries.
//
//    There are two entries:
//       XSpectrum(const FSeries& fs, const char opts=0)
//       XSpectrum(const FSeries* fs, const char opts=0)
//
void XSpectrum(const FSeries& fs, const char *opts=0) {
    XSpectrum(&fs, opts);
}

void XSpectrum(const FSeries* fs, const char *opts=0) {
    if (!fs || !fs->getNStep()) {
        cout << "XSpectrum: Empty series specified." << endl;
	return;
    }

    //----------------------------------  Calculate the integral series
    FSeries fi(*fs);
    fi.tIntegral();
    TString Name(fs.getName());
    Name += " (time integral)";
    fi.setName(Name.Data());

    //----------------------------------  Plot the spectrum
    Spectrum(fi, opts);
}
