//-------------------------------------  Plot a frequency series
void 
Spectrum(const FSpectrum& fs, const char *opts=0) {
    int nbin = fs.getNStep();
    if (!nbin) {
        cout << "Spectrum: Empty series specified." << endl;
	return;
    }

    //------------------------->  Exclude f=0 bin for log f scale
    float step  = fs.getFStep();
    float sfreq = fs.getLowFreq();
    float efreq = fs.getHighFreq();
    bool  LogX  = false;
    int   nHBin = nbin;
    if (sfreq == 0.0) {
        sfreq += 0.5*step;
        efreq -= 0.5*step;
	LogX   = true;
	nHBin  = nbin - 1;
    } else {
        sfreq -= 0.5*step;
        efreq -= 0.5*step;
    }

    delete gROOT->FindObject("SS001M");
    TH1F histM("SS001M", "Power Spectrum", nHBin, sfreq, efreq);

    for (int i=0 ; i<nHBin ; i++) {
        histM.SetBinContent(i+1, fs(sfreq+(i+0.5)*step));
    }

    //------------------------->  Set up the canvas
    TCanvas* c;
    if (gPad) {
        c = gPad->GetCanvas();
	c->cd();
	c->Clear();
    }
    gStyle->SetOptStat(0);
    gStyle->SetOptTitle(0);

    if (gROOT->FindObject("padM")) delete gROOT->FindObject("padM");
    TPad* padM = new TPad("padM", "Amplitude pad", 0.0, 0.0, 1.0, 0.90);

    TString Name(fs.getName());
    Name += " Power Spectrum";
    TPaveLabel* title = new TPaveLabel(0.30, 0.92, 0.70, 0.98, Name.Data());
    title->Draw();
    padM->Draw();

    //------------------------->  Draw the amplitude
    padM->cd();
    padM->SetTicks(1,1);
    if (LogX) padM->SetLogx(1);
    padM->SetLogy(1);
    TAxis* yax = histM.GetYaxis();
    yax->SetLabelSize(0.04);
    TAxis* ax = histM.GetXaxis();
    ax->SetLabelSize(0.04);
    ax->SetLabelOffset(-.02);
    histM.DrawCopy(opts);

    //------------------------->  Label axes
    TText l1;
    l1.SetTextAlign(22);
    l1.SetTextSize(0.04);
    l1.SetTextAngle(90.);
    l1.DrawTextNDC(0.03, 0.45, "Power Spectrum (ct^2/Hz)");

    l1.SetTextAngle(0.);
    l1.DrawTextNDC(0.5, 0.03, "Frequency (Hz)");

    //-------------------------> Update the canvas.
    c = padM->GetCanvas();
    c->cd();
    c->Modified();
    c->Update();
}

//-------------------------------------  Plot a frequency series
void 
Spectrum(const FSeries& fs, const char *opts=0) {
    Spectrum(FSpectrum(fs), opts);
}

//-------------------------------------  Plot a frequency series
void 
Spectrum(const FSeries* fs, const char *opts=0) {
    Spectrum(FSpectrum(*fs), opts);
}

