#include "GaussBurst.hh"
#include "rndm.hh"
#include <iostream>

using namespace std;

namespace generator {

  GaussBurst::GaussBurst(void) {
      setTriggerRate(1.0);
      setParameter("A",     1.0);
      setParameter("Sigma", 0.0);
      setParameter("Width", 6.0);
  }

  GaussBurst::GaussBurst(double Amp, double Sigma, double w)
  {
      setTriggerRate(1.0);
      setParameter("A",     Amp);
      setParameter("Sigma", Sigma);
      setParameter("Width", w);
  }

  GaussBurst::~GaussBurst(void) {
  }

  GaussBurst*
  GaussBurst::clone(void) const {
      return new GaussBurst(*this);
  }

  //====================================  Generate sine-gaussian time-series
  void
  GaussBurst::getSeries(const Time& t0, Interval dT, int N, gen_sample_type* d) {

      //--------------------------------  Get the parameters
      double Ampl  = getNumeric("A");
      double sigma = getNumeric("Sigma");
      double Width = getNumeric("Width");

      if (getDebug()) cout << "  Generating GaussBurst(A=" << Ampl 
			   << ", Sigma=" << sigma << ", W=" << Width
			   << ")" << endl;

      //-------------------------------  Set up to loop
      double xWid  = Width*sigma;
      double xInc  = dT;
      double xLow  = double(t0 - getTrigTime());
      double twoSigmaSq = 2.0*sigma*sigma;
      for (int i=0 ; i<N ; ++i) {
	  double x = xLow + i*xInc;
	  if (x + xWid < 0) continue;
	  if (x > xWid) break;
	  d[i] += Ampl * Rannor() * exp(-x*x/twoSigmaSq);
      }
  }

  //====================================  Get the full width (2*Width*sigma)
  Interval
  GaussBurst::getDuration(void) const {
      double Sigma = getNumeric("Sigma");
      double Width = getNumeric("Width");
      return Interval(2*Width*Sigma);
  }

} // namespace generator
