//    TrigEnv template program
//
#include "TrigTemplate.hh"
#include "TSeries.hh"
#include <iostream>

EXECDAT(TrigTemplate)

using namespace std;

//======================================  Monitor constructor
TrigTemplate::TrigTemplate(int argc, const char* argv[]) 
  : TrigEnv(argc, argv), mSeisx(0)
{
  getDacc().addChannel("H0:PEM-LVEA_SEISX", 0, &mSeisx);
}

//======================================  Monitor destructor
TrigTemplate::~TrigTemplate(void) {
}

//======================================  Monitor specific data processing
void 
TrigTemplate::ProcessData(void) {
    cout << "Frame read, Start: " << mSeisx->getStartTime() << " duration: "
	 << mSeisx->getInterval() << endl;
}

//======================================  Trigger processing and selection
bool 
TrigTemplate::ProcessTrigger(const trig::TrigBase& t) {
    cout << "Trigger read, ID: " << t.getID() << " subID: " << t.getSubID()
         << " time stamp: " << t.getTime() << endl;
    return true;
}
