/* -*- mode: c; c-basic-offset: 4; -*- */
#ifndef GDS_ATOMIC_H
#define GDS_ATOMIC_H

#ifdef __GNUC__
#define GNU_GCC_VERSION (__GNUC__*100 + __GNUC_MINOR__)
#else
#define GNU_GCC_VERSION 0
#endif

#if (GNU_GCC_VERSION >= 401) && (!defined(__i386) || defined(__i486) || defined(__i686))
#define USE_BUILTIN_ATOMICS 1
#endif
#if (GNU_GCC_VERSION == 401) && defined(__sparc)
#undef USE_BUILTIN_ATOMICS
#endif
#ifdef USE_BUILTIN_ATOMICS
#define ATOMIC_POSTINC(x) __sync_fetch_and_add(&(x),1)
#define ATOMIC_POSTDEC(x) __sync_fetch_and_sub(&(x),1)
#define ATOMIC_PREINC(x)  __sync_add_and_fetch(&(x),1)
#define ATOMIC_PREDEC(x)  __sync_sub_and_fetch(&(x),1)
#endif

#endif /* !defined(GDS_ATOMIC_H) */
