/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef TABLE_TABLEIO_HH
#define TABLE_TABLEIO_HH

#include <string>

namespace table {

    class Table;

    /**  The tableIO class supplies a common API for reading tables from text,
     *  xml or hdf5 files.
     */
    class tableIO {
    public:
	/**  Default constructor.
	 *  \brief default constructor.
	 */
	tableIO(void) : _debug(0) {}

	/**  Virtual destructor.
	 *  \brief Destructor.
	 */
	virtual ~tableIO(void) {}

	/**  Get the debug print level.
	  *  \brief Debug level.
	  *  \return Debug print level.
	  */
	int debug(void) const;

	/**  Read a table from the specified file and table name.
	 *  \brief Read a table.
	 *  \param path File path string.
	 *  \param name Table name string.
	 */
	virtual void readTable(Table& tabl, const std::string& path, 
			       const std::string& name) = 0;

	/**  Set the debug print level.
	  *  \brief Debug level.
	  *  \param level Debug print level.
	  */
	void set_debug(int level);

	/**  Name of the most recent table read/written.
	 *  \brief Table name.
	 *  \return Constant reference to the tablename string.
	 */
	const std::string& tableName(void) const;

	/**  Write a table to the specified file and table name.
	 *  \brief Write a table.
	 *  \param path File path string.
	 *  \param name Table name string.
	 */
	virtual void writeTable(const Table& tabl, const std::string& path, 
				const std::string& name) = 0;
    protected:
	std::string _tableName;
	int         _debug;
    };

    //==================================  Inline accessors
    inline int
    tableIO::debug(void) const {
	return _debug;
    }

    inline const std::string&
    tableIO::tableName(void) const {
	return _tableName;
    }

    //==================================  Inline mutators
    inline void
    tableIO::set_debug(int lvl) {
	_debug = lvl;
    }

}  // namespace table

#endif // !defined(TABLE_TABLEIO_HH)
