/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef TBLPGM_FORMAT_HH
#define TBLPGM_FORMAT_HH
#include <string>

namespace table {

    /** %Table program numeric print format class.
      * \brief Format specified.
      * \author John zweiizg <john.zweizig@ligo.org>
      * \version $Id$
      */
    class format_spec {
    public:

	/**  Numeric print type
	 */
	enum num_format {
	    kDefault,  ///< Just print it.
	    kFixed,    ///< Print a fixed point number
	    kSci       ///< Print scientific notation with specified precision
	};
    public:
	/**  Default constructor.
	  *  \brief default constructor.
	  */
	format_spec(void);

	/**  Initializing constructor.
	  *  \brief Initializing constructor.
	  *  \param fmt Format string.
	  */
	format_spec(const std::string& fmt);

	/** Destroy a format specifier.
	  * \brief Destructor.
	  */
	~format_spec(void);

	/**  Set format specification from a format string.
	  *  \brief Parse format string
	  *  \param fmt Format string.
	  */
	void parse(const std::string& fmt);

	/**  Convert the numeric data to a formatted string.
	  *  \return Put numeric as string
	  *  \param num Numer ic data to be formatted
	  *  \return formatted string. 
	  */
	std::string put_string(double num) const;

	/**  Print numeric data as fixed point numbers.
	  *  \brief Fixed point output
	  *  \param prec Number of digits to the right of the decimal point.
	  */
	void setFixed(int prec);

	/**  Print numeric data in c++ default notation.
	  *  \brief Default notation output
	  *  \param prec Number of digits to the right of the decimal point.
	  */
	void setPrecision(int prec);

	/**  Print numeric data in scientific notation.
	  *  \brief Scientific notation output
	  *  \param prec Number of digits to the right of the decimal point.
	  */
	void setScientific(int prec);
    private:
	num_format mNumFormat;
	int        mPrecise;
	int        mWidth;
    };

};

#endif // !defined(TBLPGM_FORMAT_HH)
