#ifndef READMETADATA_HH
#define READMETADATA_HH

#include <vector>
#include <string>
#include "events/Set.hh"
#include "events/ColumnType.hh"
#include "events/Value.hh"


namespace events {

/** @name ASCII Meta Data Functions
  * This section contains functions to read ASCII formatted Meta Data.
  * @memo functions to read ASCII formatted Meta Data.
  * @author Written January 2002 by Masahiro Ito and Daniel Sigg
  * @version 1.0; Last modified Jan. 12, 2002
  */
//@{

   /** Read ASCII formatted meta data (comma delimited with Column names)
		 saved by GUILD into an event set.
       @memo Read ASCII formatted meta data saved by GUILD into an event set.
       @param filename Name of file
       @param eventset set to store meta data
	******************************************************************/
   void ReadMetaData(const char* filename, events::Set& eventset);

   /** Split words in a comma delimited line of string and put them into a vector.
       @memo Split words in a comma delimited line of string and put them into a vector.
       @param line line of string
       @param element string vector to hold words
	******************************************************************/
   void ParseMetaData(const std::string line, 
                     std::vector<std::string>& element);

   /** Convert a character array to Value in specified type.
       @memo Convert a character array to Value in specified type.
       @param source pointer to a character array 
		 @param type type of value
       @param val events::Value to store conveted value.
	******************************************************************/
   void ConvertValue (const char* source, events::ColumnType::Enum type, 
                     events::Value& val);

//@}
}

#endif
