//////////////////////////////////////////////////////////////////////////
//  									//
//  Condition								//
//  									//
//////////////////////////////////////////////////////////////////////////

#include <time.h>
#include "events/Condition.hh"
#include "events/ConditionLogic.hh"
#include "events/Event.hh"
#include "events/Window.hh"
#include "events/Argument.hh"


namespace events {

//______________________________________________________________________________
   bool Condition::operator() (const Event& event, bool& val) const
   {
      Window w (const_cast<Event*>(&event));
      return Evaluate (w, val);
   }

//______________________________________________________________________________
   static ConditionLogic gTrue (ConditionLogic::opTrue);
   const Condition& Condition::True()
   {
      return gTrue;
   }

//______________________________________________________________________________
   static ConditionLogic gFalse (ConditionLogic::opFalse);
   const Condition& Condition::False() 
   {
      return gFalse;
   }

}
