/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Module Name: webxmledit						*/
/*                                                         		*/
/* Module Description: web server for monitor data			*/
/*                                                         		*/
/* Revision History:					   		*/
/* Rel   Date     Programmer  	Comments				*/
/* 0.1	 4Jan02   D. Sigg    	First release		   		*/
/*                                                         		*/
/* Documentation References:						*/
/*	Man Pages: webxmledit.html					*/
/*	References: none						*/
/*                                                         		*/
/* Author Information:							*/
/* Name          Telephone       Fax             e-mail 		*/
/* Daniel Sigg   (509) 372-8132  (509) 372-8137  sigg_d@ligo.mit.edu	*/
/*                                                         		*/
/*                                                         		*/
/*                      -------------------                             */
/*                                                         		*/
/*                             LIGO					*/
/*                                                         		*/
/*        THE LASER INTERFEROMETER GRAVITATIONAL WAVE OBSERVATORY.	*/
/*                                                         		*/
/*                     (C) The LIGO Project, 1999.			*/
/*                                                         		*/
/*                                                         		*/
/* Caltech				MIT		   		*/
/* LIGO Project MS 51-33		LIGO Project NW-17 161		*/
/* Pasadena CA 91125			Cambridge MA 01239 		*/
/*                                                         		*/
/* LIGO Hanford Observatory		LIGO Livingston Observatory	*/
/* P.O. Box 1970 S9-02			19100 LIGO Lane Rd.		*/
/* Richland WA 99352			Livingston, LA 70754		*/
/*                                                         		*/
/*----------------------------------------------------------------------*/

#ifndef _LIGO_WEBXMLEDIT_H
#define _LIGO_WEBXMLEDIT_H

#include "web/xmlform.hh"



/** @name Web server for editing LIGO lightweight data
    This web server displays data from XML files and allows
    the user to edit them.
    Result pages are created dynamically.

    \begin{verbatim}
    usage: webxmledit [-d 'basedir'] [-e 'ext'] [-t 'title'] \
                      [-p 'port'] [-l 'logfile'] [-fv]
           -d 'basedir' : base directory of the XML files (default '.')
           -e 'ext' : specifies the file extension (default 'xml')
           -t 'title' : title of web page
           -p 'port' : specifies a port number other than 80
           -l 'logfile' : specifies a log file
           -f : don't fork
           -v : verbose
    \end{verbatim}

    @memo XML edit web server
    @author Written March 2002 by Daniel Sigg
    @version 1.0
 ************************************************************************/

#endif // _LIGO_WEBXMLEDIT_H
