#include "PConfig.h"
#include <string.h>
#include <dlfcn.h>
#include <iostream>
#include "monapi/monaccess.hh"


namespace monapi {
   using namespace std;


#if defined(P__WIN32)
#define RTLD_LOCAL		0
#define LIBRARY1_NAME		"libmonlmsg.dll"
#define LIBRARY2_NAME		"libmondmtsrvr.dll"
#elif defined(P__DARWIN)
#define LIBRARY1_NAME		"libmonlmsg.dylib"
#define LIBRARY2_NAME		"libmondmtsrvr.dylib"
#else
#define LIBRARY1_NAME		"libmonlmsg.so"
#define LIBRARY2_NAME		"libmondmtsrvr.so"
#endif
#define FUNC1			"getMonAccessLMSG"
#define FUNC2			"getMonAccessDMTServer"


   typedef monaccess* (*func_t) (void);

   std::string gDefaultInterface;


//////////////////////////////////////////////////////////////////////////
//                                                                      //
// monaccess                                                            //
//                                                                      //
// virtual monitor access                                               //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
   monaccess::monaccess (const char* server) 
   {
      setServer (server);
   }

//______________________________________________________________________________
   monaccess::~monaccess () 
   {
   }

//______________________________________________________________________________
   bool monaccess::setServer (const char* server) 
   {
      fServer = server ? server : ""; 
      return true;
   }

//______________________________________________________________________________
   const char* monaccess::getServer () const 
   {
      return fServer.c_str(); 
   }

//______________________________________________________________________________
   monaccess* monaccess::install (const char* opt)
   {
      void* handle;
      func_t get;
      string lib;
      string func;
   
      if (!opt && !gDefaultInterface.empty()) {
         opt = gDefaultInterface.c_str();
      }
      if (opt && (strcmp (opt, "lmsg") == 0)) {
         lib = LIBRARY1_NAME;
         func = FUNC1;
      }
      else {
         lib = LIBRARY2_NAME;
         func = FUNC2;
      }
   
      handle = dlopen (lib.c_str(), RTLD_NOW | RTLD_LOCAL);
      if (handle == 0) {
         cerr << "Unable to load " << lib << endl;
         return 0;
      }
      get = (func_t)dlsym (handle, func.c_str());
      if (get == 0) {
         cerr << "dlsym failed for " << func << endl;
         return 0;
      }
   
      return get();
   }

//______________________________________________________________________________
   void monaccess::setDefaultInterface (const char* opt)
   {
      gDefaultInterface = opt ? opt : "";
   }

}
