/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef TRIG_S6SEGWRITER_HH
#define TRIG_S6SEGWRITER_HH

#include "Segment.hh"
#include "ProcList.hh"
#include "TrigWriter.hh"
#include <list>

namespace trig {

    class TrigBase;
    class Segment;

    /**  The S6SegWriter class writes triggers to the S6 data quality segment 
      *  database.
      *  @memo S6 segment writer API
      *  @author J. Zweizig
      *  @version 1.0; Last modified December 15, 2008
      */
    class S6SegWriter : public TrigWriter {
    public:
	typedef std::list<Segment>        seg_list;
	typedef seg_list::iterator        seg_iter;
	typedef seg_list::const_iterator  const_seg_iter;

    public:
	/**  Segment writer default constructor.
	  */
	S6SegWriter(void);

	/**  Segment writer destructor.
	  */
	~S6SegWriter(void);

	/**  Add a trigger to the list. The S6 database writer deals only 
	  *  with segments so this method is effectively null.
	  */
	lmsg::error_type addTrigger(const TrigBase& t, const TrigProc& p);

	/**  Add a segment to the list. Both the segment and the trigger 
	  *  are recorded
	  */
	lmsg::error_type addSegment(const Segment& s,  const TrigProc& p);

	/**  Clear the list of segments and processes.
	  */
	void clear(const Time& start, const Time& end);

	/**  Return the start time of the earliest segment
	  */
	Time getEarly(void) const;

	/**  Return the mode flag for this segment writer (kS6Wrt).
	  */
	TrigWriter::trig_mode getMode(void) const;

	/**  Get the number of segments stored.
	  */
	int getNSegs(const Time& t) const;

	/**  Return a constant reference to the segment list.
 	  */
	const seg_list& refSegList(void) const;

	/**  Set the default process ID.
 	  */
	lmsg::error_type setProcess(const TrigProc& p);


	/**  Write the segment xml tables to the specified file.
	 */
	lmsg::error_type write(const std::string& file, const Time& start, 
			       const Time& end) const;

    private:
	ProcList mProcList;
	seg_list mSegList;
    };

    //==================================  Inline methods.
    inline TrigWriter::trig_mode 
    S6SegWriter::getMode(void) const {
	return kSegWrt;
    }

    //==================================  Inline methods.
    inline const S6SegWriter::seg_list& 
    S6SegWriter::refSegList(void) const {
	return mSegList;
    }




} // namespace trig

#endif // TRIG_S6SEGWRITER_HH
