#ifndef ConfigInfo_HH
#define ConfigInfo_HH

#include <deque>
#include "TSeries.hh"
#include "Histogram1.hh"
#include "html/table.hh"
#include "Trend.hh"
#include "IIRFilter.hh"

#include "MonServer.hh"
#include "ConfContainer.hh"

#include "LPEFilter.hh"

typedef  std::vector<EventInfo> EventList;

// decay time = 10 seconds
const static float kDecay = exp(-log(2.0)/ 10 );

const static double kHistUpdateInt = 3600.0;
// const static double kHistSUpdateInt = 3600.0;
// const static double kHistLUpdateInt = 3600.0 * 24.0;
// time series contains 24 * 60 arrays (updated every min)
const static int kTSMaxNArray = 24 * 60;
const static double kTSUpdateInt = 60.0;
//const static Histogram1 kHistogramTemplate ( "",  500, 0., 500. );

class ConfigInfo {
	public:
		//----------------------- configuration
		/// threshold info container.
		ThresholdInfo* fThreshold;

		/// filter info container.
		//FilterCoef fFilter;
		FilterInfo* fFInfo;

		///
		Parameter* fParam;
		///
		HistogramInfo* fHist;

		/// comment.
		std::string fComment;

		//IIRFilter fFilter;
		Pipe* fFilter;

		// LPEFilter
		LPEFilter* fLPEFilter;

		//----------------------- Histogram & TSeries

		/// temp histograms
		std::deque<Histogram1> fHist_buff;

		/// 2hr histogram.
		Histogram1 fHistS;

		/// 24hr histogram.
		Histogram1 fHistL;

		/// time series of event rate.
		std::deque<int> fRate;
		TSeries fTSRate;
		Time fTSRateStartTime;



		//----------------------- statistics
		/// std. dev. of filtered data
		double fSDev;

		/// last norm for std. dev.
		double fLastNorm;

		/// sum of  std. dev.
		double fSumSDev;

		/// counter for std. dev. averaging.
		int fSumSDevCount;

		int fEventCountHigh;
		int fEventCountLow;

		/// max snr within Log interval.
		double fMax;

		EventInfo fEvent;

		/** Constructor.
		  @memo Constructor
		 ******************************************************************/
		ConfigInfo ();

		ConfigInfo ( const ConfigInfo& conf );
		/** Destructor.
		  @memo Destructor
		 ******************************************************************/
		~ConfigInfo ();

		//bool Init ( const char* name, const char* ifo, const int sfreq, const Time& t );
		bool Init ( const int sfreq, const Time& t );

		bool operator== (const ConfigInfo& conf) const;

		ConfigInfo& operator= (const ConfigInfo& conf);

		void ClearStat();

		void Dump () const;

		void ProcessEvent ( const TSeries& tsold, const float mean, EventList& elist );

		void ResetStat ( const char* name, const char* ifo, MonServer& mserv, 
				Trend& trend, const std::vector<TSeries>& tlist, int ts_interval  );

		void UpdateHistogram ( const Time& t, Trend& trend );

		void OutputLog ( html::table& results );

		void ConfigLog ( html::table& results );

		void Attention ();

		void TSSave ( std::ostream& out );

	private:
		//----------------------- buffer
		//static float sfData [];
		static TSeries sfTSeries;
		static int sfData_attn [];

		/// trenc channel name
		std::string fTrendName;

		void GetRMS ( int n );

		double GetThresholdLow () const;

		double GetThresholdHigh () const;

		bool CheckTrigCondition ( int n ) const;
};

#endif
