
#include "Interval.hh"

#include "MonitorConf.hh"

   using namespace std;

//
// MonitorConf
//

	// constructor
   MonitorConf::MonitorConf () {
      SetDefault();
   }

   MonitorConf::~MonitorConf(void)
   {
   }

   void MonitorConf::SetDefault () {
      fName = "glitchMon";
   
      fSite = kLHO;
   
      fDataPath = "";
   
      //fLogPath = "";
      fDoLog = false;
   
      fDuration = Interval ( 0.0 );
   
      fLogInterval = Interval ( 3600.0 );
   
      fDoTrigger = false;
   
      fDoTrend = false;
   
   	// default value is 12 hours.
      fTSInterval = 12 * 60;
   }

   const char* MonitorConf::GetSiteName () const {
      if ( fSite == kLHO ) {
         return "LHO";
      }
      else {
         return "LLO";
      }
   }
