/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//  Function Integrand:  Helper function for StochMon.  Reads
//  FSpectra "gammaValue" "psd_1" and "psd_2" and copies
//  gammaValue(f)/[f^{6}*psd_1(f)*psd_2(f)] into another  FSpectrum "out".  
//   version: n/a ($Date: 2012-03-13 15:07:13 -0700 (Tue, 13 Mar 2012) $;
//                 $Id: Integrand.cc 6627 2012-03-13 22:07:13Z john.zweizig@LIGO.ORG $)
//   authors: Marc J. Cenac (mjcenac@loyno.edu)
//            Brian O'Reilly (irish@ligo-la.caltech.edu)
//            John T. Whelan (jtwhelan@loyno.edu)
//original by: Kevin C. Schlaufman (kcs149@psu.edu)
//             Patrick J. Sutton (psutton@ligo.caltech.edu)
//
///////////////////////////////////////////////////////////////////////////

#include "Integrand.hh"
#include <cmath>
#include "LLOLHO_Overlap.hh"
using namespace std;

void integrand(FSpectrum& out, FSpectrum& psd_1, FSpectrum& psd_2, 
	       double secPerStride, FSpectrum& gammaValue)
{
    //----- Set FSpectrum out equal to FSpectrum psd. -- we should really 
    //      check to make sure that they are the same but we don't
    out = psd_1;
 
    //----- Initialize items necessary to prepare the integrand.
    int    nsteps = out.getNStep();
    double low_freq = out.getLowFreq();
    double f_step = out.getFStep();
    float *data = new float[nsteps + 1];
    float *data_2 = new float[nsteps + 1];
    float *gamma = new float[nsteps + 1];
    // The following prefactor is in units of (attostrain)^{-4} s^{-3}
    const double myprefactor = 1.1300758118;
    double normFact = myprefactor * secPerStride / 60;

    //----- Copy data from out object to data array.
    out.getData(nsteps + 1, data);
    psd_2.getData(nsteps + 1, data_2);
    gammaValue.getData(nsteps + 1, gamma);

    //----- Loop to invert PSDed data .  Also divide by f^(6).
    for (int i = 0; i < (nsteps + 1); i++) {
            
	data[i] = 1./(data[i]); //--put array in the denominator.

	data[i] *= 1./(data_2[i]); 

	double freq = low_freq + (i * f_step); 
	// cerr << " data[" << i << "] is " << data[i] << "    data_2[" 
	//      << i << "] is " << data_2[i] << "   freq:" << freq << endl;
	data[i] *= pow(freq,(-6)) * normFact * gamma[i] * gamma[i]; 
    }
  
    //----- Send data back to FSpectrum object.
    out.setData(nsteps + 1, data);
  
  
    //Release the memory allocate by new
    delete[] data;  
    delete[] data_2;
    delete[] gamma; 
}
