#ifndef QUADETREND_HH
#define QUADETREND_HH

#include "Pipe.hh"
#include "Time.hh"

class Quadetrend: public Pipe {
public:
  using Pipe::apply;
  using Pipe::dataCheck;
public:
  Quadetrend(void);
  Quadetrend(int N);
  virtual ~Quadetrend(void);
  virtual Quadetrend* clone(void) const;
  void setLength(int N);
  virtual TSeries apply(const TSeries& ts);
  virtual void dataCheck(const TSeries& ts) const;
  virtual void reset(void);
  Time getStartTime(void) const;
  Time getCurrentTime(void)const;
  virtual bool inUse(void) const;
private:
  unsigned int mLength;
    double mCovMtx[6];
  Time mStartTime;
  Time mCurrentTime;
};

inline Time 
Quadetrend::getCurrentTime(void) const {
   return mCurrentTime;
}

inline Time 
Quadetrend::getStartTime(void) const {
    return mStartTime;
}

inline bool 
Quadetrend::inUse(void) const {
    return mStartTime != Time(0);
}

#endif
