#ifndef DatTEMPLATE_HH
#define DatTEMPLATE_HH
#include "DecimateBy2.hh"
#include "DatEnv.hh"
#include "MonServer.hh"
#include "FixedLenTS.hh"
#include "Trend.hh"
#include <string>
#include "FSeries.hh"
#include "FSpectrum.hh"
#include "OperStateCondList.hh"

#include <iosfwd>
#include <list>
#include <vector>
#include "Pipe.hh"
#include "Time.hh"
#include "Interval.hh"
#include "TSeries.hh"
// #include "wseries.hh"

#include "html/color.hh"
#include "html/document.hh"
#include "html/table.hh"
#include "html/size.hh"
#include "html/text.hh"
#include "html/writer.hh"

#include <fstream>
#include <complex>
// typedef std::complex<float> f_complex; 
// typedef double wavereal;
// typedef wavearray<wavereal> WaveData; 
//
//    Data Monitor template class.

/**  @name DatTemplate
  *  @memo Template of a data environment (DatEnv) based monitor.
  *  The DatTemplate monitor is a template for a data monitor program.
  *  DatTemplate makes a simple calculation of the standard deviation of
  *  a specified channel (by default H0:PEM-LVEA_SEISX), serves the result 
  *  for display by the DMT viewer and stores the result as a minute trend.
  *
  *  {\bf {\Large Running DatTemplate}}
  *
  *  The DatTemplate command line syntax is:
  *  \begin{verbatim}
        DatTemplate [-channel <channel>] [-frames <number>] [-stride <time>] \
                    [-filter <filter>] [-settle <s-time>] [-dvIndex]
     \end{verbatim}
  *  The #<number># argument specifies the number of data strides to process
  *  before terminating the program. The #<time># argument specifies the data
  *  stride. If "-dvIndex" is specified, a trend index file will be written
  *  to '\$DMTOUTPUT/channel.cnf'.
  *
  *  {\bf {\Large Configuration File}}
  *
  *  DatTemplate uses a fixed configuration. There is therfore no 
  *  configuration file
  *
  *  {\bf {\Large DatTemplate Output}}
  *
  *  {\bf Trend channels}
  *  DatTemplate produces a minute trend of the sigma value called 
  *  #<channel>_sigma#
  *
  *  {\bf Monitor data channels}
  *  DatTemplate publishes a time series history of the sigma values 
  *  wi_th the name #<channel>_sigma#
  *
  *  @author John Zweizig; Caltech/LIGO
  *  @version 1.1; Last modified August 12, 2004
  */
//{
//}

class Pipe;

class check {

private:
  float q;
  float ave_of_x;
  float ave_of_xsqr;
  float prestd_of_x;
  float powerq;
  float temp1,temp2,temp3,temp4;
  long int loop;
public:
  int onhold;
  check(void);
  check(float Q);
  bool datvalid(float newx,float oldwght, float newght,bool weight,int db);
  void restore();
  void updt_temp();
};

class SixtyHertzMon {

public:
  SixtyHertzMon(void);
  SixtyHertzMon(float hf,int a,int b,std::string c,std::string d,float e,float* g,float* h);
  void  LoopInit(Time t,long l,float cali);
  void  CalVolFreq(FSpectrum& ss);
  void Heterodyne(FSpectrum& ss,int PadLen);
  void SidebandSeek(int PadLen,bool locked);
  FSpectrum display,HeteroedSigView[10],UnHeteroedSigView[10];
  std::string historyfile,currentfile;
  float volfreq;
  long int goodloop[1441],GoodloopNum;
private:
  Interval    mStep;          //  Time stride.
  float mstep;
  std::string VoltageChannel,SignalChannel;       //  Channel name
  float HeteroedSignal[40000],UnHeteroedSignal[40000];
  float HeteroedSignal_bckup[40000],UnHeteroedSignal_bckup[40000];
  int PadLen;
  float cali_fre;
  long TotalLoopnum,InvalidNum;
  bool datvalid(float* dat,int n);
  int peakedge(float* dat,int n,int direction);
  float arraysum(float* dat,int n);
  float arraystd(float* dat,int n);
  int ncf;
  float cf[10];
  float HeteroFre;
  float peaks[10000];
  float sidebands[1000];
  float dsidebands[1000];
  int blast;
  float Q;
  check check_sum[10];
  check check_std;
  check check_sdnum;
  float NB;
  float reloldwght_sum;
  float reloldwght_sum_bckup;
  float oldwght,newght;
  float oldwght_bckup;
  float oldwto1;
  Time Tnow;
  int NoiseEffectNum;
  int db;
  bool gooddata;
  bool NoiseEffect;
  float N;  //weight for new data
  float expfactor;
  float dat1[40000],dat3[40000];
  int j1,j2,j3;
  int ite;
  int nsidebands;
  FSpectrum spechet;
  float sumexp1[40000],sumexp2[40000];
};


class DatTemplate : public DatEnv, MonServer {
public:
    DatTemplate(int argc, const char *argv[]);  // Constructor
    ~DatTemplate(void);                         // Destructor
    void ProcessData(void);                     // Process 1 data stride
    void Attention(void);                       // Handle Message signal.
private:
    int         maxFrame;       //  Number of frames to process
    Interval    mStep;          //  Time stride.
    Trend       mTrend;         //  Trend writer
    std::string hfstr[10];
    std::string mFilter;        //  Filter description
    Interval    mSettle;        //  Settling time.
    std::string mSigmaName;     //  Channel data and trend name
    Pipe*       mPipe;          // Pipe pointer
    TSeries     SingalTSeries[3],VoltageTSeries[3];
    FSeries     ff;
    FSpectrum   ss;
    float tspd[10];
    float mstep;
    int PadLen;
    bool newfolder();
    bool newfile();
    float cf[10]; 
    int nhf;
    std:: string HtmlFilename;
    std::string htmldir;
    std::string HistFolder;
    bool DispOnline;
    std::ofstream indexfile;
    SixtyHertzMon myObj[3];
    bool nfile;
    std::string current_month;
    std::string historyfile;
    float TrendValue;
    OperStateCondList mOSC;
    std::string BothArmLocked;
    int db;
    std::string VoltageChannel,SignalChannel;       //  Channel name
    int ncf;
    float NB;
    float HeteroFre[2];
    Time Tnow;
    long TotalLoopnum;
  float cali_fre;
 };




#endif     //  DatTEMPLATE_HH
