//Initial version v0.0 by Szabi Marka

#include "ShapeMon.hh"

#ifndef __CINT__

#include <iostream>
#include <fstream>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <time.h>
#include <cmath>
#include "TSeries.hh"
#include "FSeries.hh"
#include "FSpectrum.hh"
#include "Hanning.hh"
#include "Dacc.hh"
#include "FixedLenTS.hh"
#include "DVector.hh"

#include "Interval.hh"
#include "Histogram1.hh"
#include <unistd.h>
#include <sstream>

//--------------------------------------  Generate the main routine.
EXECDAT(ShapeMon)
#endif               // !def(__CINT__)

using namespace std;

time_t ct;
const char* Ch;
const char* Fname;
float duration=1;
//float g[33000];
int i,j;
float IDO=0, scale=1.0;
bool Epics = false;

#ifdef GiveGraph
static FILE *p1;
#endif
char GRAPH[128] = "graph -T X";
//char FNAME[128] = "/tmp/GRAPH_";
char COMM[256]; 
int NumBins = 128;
float MinFrq = 1/10.0;
float MaxFrq = 100.0;

char TTAG_Ch[40]  = "xxx";
char ALIVE_Ch[40] = "xxx";

float RefSpec[128];
char      Alive(0);

typedef float VecType;
const char* const BurtHeader =
   "--- Start BURT header\n"
   "Time:     Thu Dec 19 12:06:08 2002\n"
   "Login ID: barker (Dave Barker)\n"
   "Eff  UID: 246\n"
   "Group ID: 10\n"
   "Keywords:\n"
   "Comments: h2sosepics\n"
   "Type:     Absolute\n"
   "Directory /opt/CDS/d/barker\n"
   "Req File: /cvs/cds/lho/target/h2sosepics/autoBurt.req\n"
   "--- End BURT header\n";

// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

ChannelList::ChannelList( const string& chan, 
                const string& trend, 
                const string& epics, 
	        const string& alarm, 
		const float MarginalTh, 
		const float ErrorTh)                // GPSTimer Costructor
  : mChannel(chan), 
    mTrend(trend),
    mEpics(epics),
    mAlarm(alarm),
    mMarginalTh(MarginalTh),
    mErrorTh(ErrorTh)
{
}

const char* 
ChannelList::getTrendName(void) const {
    return mTrend.c_str();
}

const char* 
ChannelList::getEpicsName(void) const {
    return mEpics.c_str();
}

const float 
ChannelList::getMarginalTh(void) const {
    return mMarginalTh;
}

const float 
ChannelList::getErrorTh(void) const {
    return mErrorTh;
}

const char* 
ChannelList::getAlarmName(void) const {
    return mAlarm.c_str();
}

ChannelList::~ChannelList(void) {
}

const char* 
ChannelList::getChannelName(void) const {
    return mChannel.c_str();
}


// Creates a random set of 3*N alphanumeric characters (N numbers+N 
// capitals+Nsmalcaps) This should be unique enough ...
char* RandomStr(int N)
   {
      if(N>60) N=60;
      static char s[180];
   
      srand(time(0) - 1023285971);
   
      for(int t=0; t<3*N; t+=3) {
         s[t]   = 48 + (int) (10.0*rand()/(RAND_MAX+1.0)); // Numeric
         s[t+1] = 65 + (int) (26.0*rand()/(RAND_MAX+1.0)); // Capital
         s[t+2] = 97 + (int) (26.0*rand()/(RAND_MAX+1.0)); // Small caps
      }
      return s;
   }

//--------------------------------------  Skeleton object constructor.
ShapeMon::ShapeMon(int argc, const char *argv[]) 
  : DatEnv(argc, argv), MaxFrame(999999)
{
    //----------------------------------  Look for arguments

  // Needs at least two arguments !!!
  if (argc<2) { cout << " Usage: dump <Channel name> <Duration[0.001<=s<=65536 secs] [Reference Spectra]" << endl << endl; exit(1); }

  // Expects channel name as first argument...
    if (strlen(argv[1])>10) Ch=argv[1];
    //else {cout << "Give me channel!" << endl; exit(1); }
      else Ch="H0:PEM-LVEA_SEISZ";

  // Expects second argument as seconds...
    duration = strtod(argv[2],0);
    if (duration<0.001) duration = 0.001;
    if (duration>65536) duration = 65536;

  // Expect third argument as a file name containing the configuration information...
    if (strlen(argv[3])>2) Fname=argv[3];
      else Fname="SeisMon.conf";

    char line[256];
    char* argl[32];
    ifstream in(Fname);
      if (in.bad()) {
         cerr << "Unable to open configuration file: " << Fname  << endl;
         finish();
         return;
      }
#ifdef GD_DEBUG  
    cout << "Configuration file " << Fname << " is found. Reading info..." << endl;
	 cout << endl << "----------|||----------" << endl;
#endif

    while (!in.getline(line, sizeof(line)).eof()) {
      if ( !( line[0] == '#' ) ) {
        int  len   = in.gcount();
        int  narg   = 0;
        bool inArg  = false;
        bool YesArg = false;
#ifdef GD_DEBUG  
        cout << len << " - " << line << endl;
#endif
        for ( i=0; i < len; i++) {
          if (!line[i] || line[i] == '\n' ) {
              line[i] = 0;
              break;
          } else if (line[i] == ' ' || line[i] == '\t' || line[i] == ',' ) {
              inArg = false;
              line[i] = 0;
            } else if (!inArg) {
                inArg  = true;
                YesArg = true;
                argl[narg++] = line+i;
              }
        }

        if ( YesArg ) {
          if ( !strcmp(argl[0], "SWITCH") ) {
            if ( !strcmp(argl[1], "Epics") ) {
#ifdef GD_DEBUG
	    cout << "Epics communication is ON!" << "\n";
#endif
	    Epics = true;
	    }
	  } else if ( !strcmp(argl[0], "ALIVE") ) {
            strcpy(ALIVE_Ch, argl[1]);
#ifdef GD_DEBUG
	    cout << "Alive Channel: " << ALIVE_Ch << "\n";
#endif
	  } else if ( !strcmp(argl[0], "TTAG") ) {
            strcpy(TTAG_Ch, argl[1]);
#ifdef GD_DEBUG
	    cout << "Time Tag Channel: " << TTAG_Ch << "\n";
#endif
	  } else if ( !strcmp(argl[0], "SEIS_CH") ) {
#ifdef GD_DEBUG
	    for (i=0;i<narg;i++) cout << argl[i] << ".|. ";
#endif
	    //----------------------------------  Set up channels
	      mChannelVect.push_back(new ChannelList(argl[1], argl[2], argl[3], argl[4], atof(argl[5]), atof(argl[6])));
#ifdef GD_DEBUG  
              cout << argl[1] << " " << argl[2] << " " << argl[3] << " " << argl[4] <<  " "  << argl[5] <<  " "  << argl[6] <<  " " << mChannelVect.size() << endl;
#endif
            //----------------------------------  Specify channels to scan
            getDacc().addChannel(argl[1]);
          }
		  }
      }
    } 
#ifdef GD_DEBUG 
	 cout << endl << "----------|||----------\n\n\n";
#endif

    //----------------------------------  set the time stride.
    float tStep(duration);
	 //getDacc().setTOCMode(false);
    getDacc().setIgnoreMissingChannel(true);
    getDacc().setStride(tStep);
}

//--------------------------------------  Skeleton object destructor.
ShapeMon::~ShapeMon() 
{
    cout << "GetData finished" << endl;
}

//--------------------------------------  Spectrum computing function.
float ShapeMon::GetSpectrum(TSeries* tx, float* Lm) {
  long   tsn  = tx->getNSample();                                 // tsn = number of time samples
  //double tsd  = tx->getInterval();
  double tav  = tx->getAverage();
  *tx-=tav; 
  //double min  = tx->getMinimum();
  //double max  = tx->getMaximum();
  
  //tx->Convert(DVecType<VecType>::getDataType());                 
  //VecType* g = reinterpret_cast<VecType*>(tx->refData());

  TSeries tw(*tx);
  Hanning hanningwindow(tsn);
  tw = hanningwindow.apply(tw);

  FSeries* fx = new FSeries;
  fx->setData(*tx);

  FSpectrum* sx = new FSpectrum;
  sx->setData(*fx);
  long   fsn = sx->getNStep();                                    // fsn = number of frequency samples
  double fsd = sx->getFStep();                                    // fsd = frequency sample spacing
 
  float* h = new float [fsn];
  sx->getData(fsn,h);

#ifdef GiveGraph
    //----------------------------------  Set up pipe to X11 display
    
    strcpy(COMM,GRAPH);
    //RandomName(FNAME,"/export/home/smarka/dump/",".svg");
    p1 = popen(COMM, "w");
#endif

#ifdef GiveGraph
  for (i=1; i<fsn; i++) {
#ifdef GD_DEBUG
    //printf("%f %f\n", (log10( (float)i * fsd )), log10(h[i]));
#endif
    //fprintf(p1,"%f %f\n", (log10( i * fsd )), log10(h[i]));
  }
#endif
  
  float  Lbin = log10(MaxFrq/MinFrq)/(float)NumBins;
  float* Lf = new float [NumBins];
  int*   Lc = new int   [NumBins];

  for (int j=0; j<NumBins; j++) {
    Lf[j]=0;
    Lm[j]=0;
    Lc[j]=0;
  }

  for (i=1; i<fsn; i++) {
    int j = (int)floor(log10(((float)i*fsd)/MinFrq)/Lbin);  
    if ( (j>=0) && (j<NumBins) ) {
      if ( ( MaxFrq >= i*fsd ) &&  ( i*fsd >= MinFrq ) ) {
        Lf[j]+=(float)i*fsd;
        Lm[j]+=h[i];
        Lc[j]++;
      }
    }
  }

  for (int j=0; j<NumBins; j++) {
    if(Lc[j]>0) {
      Lf[j] = log10(Lf[j]/(float)Lc[j]);
      Lm[j] = log10(Lm[j]/(float)Lc[j]);
    } else {
        if ( j>0 ) {
          Lf[j] = Lf[j-1];
          Lm[j] = Lm[j-1];
	}
    }
  }
  if (Lf[0] == 0) {
    Lf[0] = Lf[1];
    Lm[0] = Lm[1];
  }

  int dN = 2;
  for (int j=dN; j<NumBins-dN; j++) {
    for (i=j-dN;i<=j+dN;i++) if (i!=j) Lm[j]+=Lm[i];
    Lm[j]/=2*dN+1;
  }

  float Sum0 = 0, Sum1 = 0, Sum2 = 0, Sum3 = 0, Sum4 = 0;
  int N0 = 0, N1 = 0, N2 = 0, N3 = 0, N4 = 0;
  for (int j=0; j<NumBins; j++) {

    Sum0+=Lm[j];
    N0++;

    if ( ( Lf[j] >= -0.9 ) && ( Lf[j] <= -0.7 ) ) {
      N1++;
      Sum1+=Lm[j];
    }

    if ( ( Lf[j] >= -0.25 ) && ( Lf[j] <= 0.75 ) ) {
      N2++;
      Sum2+=Lm[j];
    }

    if ( ( Lf[j] >= 0.75 ) && ( Lf[j] <= 1.25 ) ) {
      N3++;
      Sum3+=Lm[j];
    }

    if ( ( Lf[j] >= 1.25 ) && ( Lf[j] <= 2.0 ) ) {
      N4++;
      Sum4+=Lm[j];
    }

  }

  Sum0/=(float)N0;
  Sum1/=(float)N1;
  float Sum24 = abs((Sum2+Sum4)/(float)(N2+N4));
  Sum2/=(float)N2;
  Sum3/=(float)N3;
  Sum4/=(float)N4;
  
  float ChkSum = Sum1/Sum24;
  float ChkPkk = Sum3/Sum24;

#ifdef GD_DEBUG
  cout << "CheckSum:  " << ChkSum << endl
       << "IntegSum:  " << Sum0   << endl
       << "CheckPeak: " << ChkPkk
       << endl;
#endif

#ifdef GiveGraph
  for (int j=0; j<NumBins; j++) {
#ifdef GD_DEBUG
    //printf("%f %f\n", Lf[j], Lm[j]);
#endif
    fprintf(p1,"%f %f\n", Lf[j], Lm[j]);
  }
#endif

/*
  // Compute slope and baseline crossing based on the available info 
  // Compute necessary parameters
  double T  = 0.0;
  double TT = 0.0;
  double TY = 0.0;
  double Y  = 0.0;
  double YY = 0.0;
  double N  = 0.0;
  for (j=0; j<NumBins; j++) {  
    T  += Lf[j];
    TT += Lf[j]*Lf[j];
    TY += Lf[j]*Lm[j];
    Y  += Lm[j];
    YY += Lm[j]*Lm[j];
    N++;
  }

  //    Compute slope and offset
  double Slope    = double(N)*TY - T*Y;
  double Amp      =        Y *TT - T*TY;
  double denomT   = double(N)*TT - T*T;
  double denomY   = double(N)*YY - Y*Y;
    if (denomT == 0) {
#ifdef GD_DEBUG
      cerr << "Fit is underconstrained or constant (division by zero)" << endl;
#endif
      Slope   = -9999999.9;
      Amp     = -9999999.9;
      Offset  = -9999999.9;
      Rsquare = -1;
    }
    if (denomY == 0) {
#ifdef GD_DEBUG
      cerr << "Rsquared cannot be computed! (division by zero)" << endl;
#endif
      Rsquare = -1;
    } else { 
        Rsquare  = Slope / sqrt(denomT * denomY);
        Rsquare *= Rsquare;
      }
    Slope   /= denomT;
    Amp     /= denomT;
    Offset   = ((Y)/Slope - (T))/double(N);
#ifdef GD_DEBUG  
    cout << "-------------------------------------------\n"
         << " Offset      = " << (double) (Offset)   << " \n" 
         << " Slope       = " << (double) (Slope)    << " \n"
         << " Magn. at 0  = " << (double) (Amp)      << " \n"
         << " Rsquare     = " << (double) (Rsquare)  << " \n"
         << "===========================================\n\n" << endl;
#endif    
*/
  delete [] h;
  delete [] Lf;
  delete [] Lc;
  delete    fx;
  delete    sx;

#ifdef GiveGraph
    fflush(p1);
    pclose(p1);
#endif

  if ( ( 13.0 < ChkSum ) || ( ChkSum < 2.5 ) ) {
    return(-1.0);
  } 
  
  if ( ( 4.5 < ChkPkk ) || ( ChkPkk < 0.5 ) ) {
    return(-2.0);
  } 
  
  if ( ( 2.5 < Sum0 )   || ( Sum0 < 0.8 ) ) {
    return(-3.0);
  }
  
  return(0.0);
}

//--------------------------------------  Frame processing function.
void ShapeMon::ProcessData(void) {

  float* Lm = new float [NumBins];

  for (unsigned int i=0 ; i<mChannelVect.size() ; i++) {
#ifdef GD_DEBUG
    cout << " ----- : " << mChannelVect[i]->getChannelName() << " : ----- Start " << endl;
#endif
    TSeries* tx = getDacc().refData(mChannelVect[i]->getChannelName());
	 
    double min  = tx->getMinimum();
    double max  = tx->getMaximum();

#ifdef GD_DEBUG
    cout << mChannelVect[i]->getChannelName() << "Min:" << min << " |  Max: " << max << endl;
#endif

    float yy = -4;
    for (j=0;j<NumBins;j++) Lm[j]=0;
    if ( min < max ) {
      yy = GetSpectrum(tx, Lm);
#ifdef GD_DEBUG		
      cout << "Channel is seismic :" << mChannelVect[i]->getChannelName() 
	   << " -> " << yy << endl;
    } else {
      cout << "Channel is EMPTY :" << mChannelVect[i]->getChannelName() 
	   << " -> " << "-1" << endl;
#endif
    }

    if (Epics) {
      ostringstream BurtFile;
      BurtFile << "/tmp/ShapeMon_" << RandomStr(10) << ".burt" ;
      ofstream BurtCommand(BurtFile.str().c_str(),ios::out | ios::app );
      if (!BurtCommand) {
	cerr << "WebView error: Cannot open temporary" 
	     << " data buffer (" << BurtFile.str().c_str()
	     << ")! Please check the disk usage and the"
	     << " permissions on /tmp (It should be " 
	     << "drwxrwxrwt.)." << endl;
	continue;
      }
  
      BurtCommand << BurtHeader;

      // EPICS communication every channel ...
      BurtCommand << mChannelVect[i]->getEpicsName() << "_ALARM 1 ";
      if ( yy == 0 ) {
	BurtCommand << "0\n";
      } else 
      if ( yy == -1 ) {
	BurtCommand << "2\n";
      } else
      if ( yy <  -1 ) {
	BurtCommand << "1\n";
      }

      BurtCommand << mChannelVect[i]->getEpicsName() << "_WF 128 ";
      for (j=0;j<NumBins;j++) BurtCommand << Lm[j] << " ";
      BurtCommand << endl;
#ifdef GD_DEBUG
      cout << " ----- : " << mChannelVect[i]->getChannelName() 
	   << " : ----- End " << endl;
#endif

      BurtCommand.close();

      ostringstream SystemCommand;
      SystemCommand << "/cvs/cds/epics/extensions/bin/solaris/burtwb -f " 
		    << BurtFile.str().c_str()  
		    << " ; rm " << BurtFile.str().c_str() << endl;

      // --- Executes shell script
      if ( system(SystemCommand.str().c_str()) != 0 ) {
	cerr << "WebView error: ERROR encountered "
	     << "while executing system(...) command!" << endl ;
      }
    
      // EPICS communication every minute ...
      ostringstream Comm0;
      Comm0 << "/cvs/cds/epics/extensions/bin/solaris/caput " << ALIVE_Ch 
	    << " " << abs((int)Alive) << " >> /dev/null 2>&1 \n";
      system(Comm0.str().c_str()); 
      Alive+=128;

      time_t TS;
      time(&TS);
      ostringstream Com00;
      Com00 << "/cvs/cds/epics/extensions/bin/solaris/caput " << TTAG_Ch 
	    << " \" `date -u` \"   >> /dev/null 2>&1 \n";
      system(Com00.str().c_str()); 
      // ...end of epics communication...
    }

  } //  Loop over channelVect index (i)

  delete [] Lm;
}


