//
//  Function Integrand:  Helper function for SenseMonitor.  Reads an 
//  FSpectrum "psd" and copies [f^{7/3}*psd(f)]^{-1} into a second 
//  FSpectrum "out".
//    version:  1.7 (June 26 2002)
//     author:  Kevin C. Schlaufman (kcs149@psu.edu)
//
///////////////////////////////////////////////////////////////////////////
#ifndef Integrand_HH
#define Integrand_HH

#include "FSpectrum.hh"
#include <fstream>
#include <iostream>

// This segment of code assumes that the FSpectrum object has already been
// PSDed and calibrated.  This function inverts the FSpectrum and divides
// by f^(7/3).

/** Helper function for SenseMonitor.  
  * Assigns to out the FSpectrum for $(f^{7/3} \times (psd * psd_2))^{-1}$.
  * @memo Computes integrand for range estimate integral.
  * @param out Output power spectrum.
  * @param psd Input power spectrum.
  */ 
void integrand(FSpectrum& out, FSpectrum& psd);

#endif     //  Integrand_HH
