/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef PSLMON_HH
#define PSLMON_HH

#include "DatEnv.hh"
#include "MonServer.hh"
#include "OperStateCondList.hh"
#include "Trend.hh"
#include "TrigClient.hh"
#include "AlarmClient.hh"
#include "SegAccountant.hh"
#include "TrigPar.hh"
#include "usertime.hh"
#include <list>
#include <map>

#include "PSLChan.hh"
#include "PSLSpec.hh"
#include "PSLBand.hh"
#include "PSLGlitch.hh"
#include "PSLCorr.hh"
#include "PSLfilter.hh"

#define ROOT_HISTOS


class Pipe;

//======================================  PSL monitor class
/**  The %PSLmon class is the driver for the PSL monitor, a generic monitoring 
  *  program that was first written to monitor the performance of the 
  *  Pre-Stabilized Laser (PSL). The %PSLmon class builds tables of channels
  *  to be processed, filters for use in pre-processing, and tools to be run 
  *  on the data. After reading each stride from the requested channels, it 
  *  calls each of the requested tools to proces the data and then coordinates
  *  writing trend channels and trigger files.
  */
class PSLmon : public DatEnv, MonServer, TrigClient {
public:
    PSLmon(int argc, const char *argv[]);  /// Constructor
    ~PSLmon();                             /// Destructor
    void ProcessData(void);
    void Attention(void);
    void printStats(void) const;
    void Reset(void);
    bool ReadConfig(void);
    bool chanExists(const std::string& key) const;
private:
    typedef std::map<std::string,PSLChan> ChanList;
    typedef ChanList::iterator  ChanIterator;
    ChanList  mChannels;

    typedef std::list<PSLSpec> SpecList;
    typedef SpecList::iterator  SpecIterator;
    SpecList  mSpectra;

    typedef std::list<PSLBand> BandList;
    typedef BandList::iterator  BandIterator;
    typedef BandList::const_iterator  BandConstIter;
    BandList  mBands;

    typedef std::list<PSLGlitch> GlitchList;
    typedef GlitchList::iterator  GlitchIterator;
    typedef GlitchList::const_iterator  GlitchConstIter;
    GlitchList  mGlitches;

    typedef std::list<PSLCorr> CorrList;
    typedef CorrList::iterator  CorrIterator;
    CorrList  mCorrs;

    typedef std::map<std::string, PSLfilter> FiltrList;
    typedef FiltrList::iterator  FiltrIterator;
    FiltrList mFiltr;

    TrigPar   mDict;
    double    mStride;

    std::string    mCFile;
    Trend     mTrend;
    OperStateCondList mOSC;
    AlarmClient mAlarm;
    trig::SegAccountant mSegAcct;

    //----------------------------------  Global statistics
    Time     mStartData;
    Time     mStartProcess;
    Interval mProcessedTime;
    user_timer mUTimer;
};

#endif     //  PSLMON_HH
