#ifndef WPIPE_WCHUNK_HH
#define WPIPE_WCHUNK_HH

// WCHUNK Omega Pipeline function to analyze a single block of data
//
// usage: wchunk(blockStartTime, tiling, eventTime, 
//               parameterFile, frameCacheFile, outputFiles, debugLevel);
//
//   blockStartTime        gps block start time
//   tiling                q tiling structure
//   eventTime             eventTime to focus search around ([])
//   parameters            parameter structure
//   frameCache            frame cache structure
//   outputFiles           structure of output file names
//   debugLevel            verboseness level of debug output
//
// If given output arguments, WCHUNK will output the following fields:
//
//   triggersThresholded   thresholded triggers
//   triggersDownselected  downselected triggers
//   triggersVetoed        vetoed triggers
//   triggersClustered     clustered triggers
//   triggersCoincident    coincident triggers
//   event                 event information
//   skymap                bayesian skymap
//   transforms            transform structure
//
// The specified debugLevel controls the amount of detail in the output log.
// A debugLevel of unity is assumed by default.
//
// See also WPARAMETERS, WTILE, WREADDATA, WRESAMPLE, WCONDITION, WTRANSFORM,
// WTHRESHOLD, WSELECT, and WWRITEEVENTS.
//
// Authors:
// John Zweizig <john.zweizig@ligo.org>               Based on wblock

#include "wtypes.hh"
#include "wstream_chan.hh"
#include "Time.hh"

class MultiDacc;

namespace wpipe {

  class wframecache;
  class woutput;

  class wchunk {
  public:
    wchunk(void);
    int process(double blockDuration, double blockOverlap, 
		strchan_vect& cv, MultiDacc& frameCache, woutput& outputFiles, 
		int debugLevel, str_vect& channelNames);
  private:
    Time      currentTime;
    size_t    blockNo;
  };
} // namespace wpipe

#endif // !defined(WPIPE_WCHUNK_HH)
