/***************************************************************************
    File        : PowerSpectrum.h
    Description : Estimates the Power Spectrum of a time series based on
                  a Welch's averaged, modified periodogram
 ---------------------------------------------------------------------------
    Begin       : Thu Dec 11 2003
    Author(s)   : Roberto Grosso
 ***************************************************************************/

/*! \file PowerSpectrum.h
 *  Computes the power spectrum density using the
 *  Welch method.
 */


#ifndef __POWERSPECTRUM_H
#define __POWERSPECTRUM_H

// System Libs
#include <vector>

// Project files
#include "Types.h"
#include "Singleton.h"
#include "Numeric.h"
#include "Window.h"
#include "Fourier.h"

namespace gwd {

  //! Power Spectrum Density using the Welch method.
  class PowerSpectrum {
  public:
    /** Default constructor */
    PowerSpectrum() {}

    /** Destructor */
    virtual ~PowerSpectrum() {}

    // Methods
    /**
    ** Computes the power spectrum density using Welch's modified
    ** periodogram.
    ** @param noOfFreq no. of frequencies in pwd.
    ** @param noverlap interval overlap, [0,1).
    ** @param signal input signal.
    ** @param psd output power spectrum density.
    ** @return true in case of success, else return false.
    **/
    bool WelchPowerSpectrumDensity(const unsigned int noOfFreq,const double overlap,
                                   const Vector& signal,
                                   Vector& psd);
  private:

  };



} // namespace gwd
#endif // __POWERSPECTRUM_H

