#ifndef VWMATH_CC
#define VWMATH_CC

#ifndef __CINT__
#include <time.h>
#include <iostream>
#include <fstream>
#include <string.h>
#include "TSeries.hh"
#include "Time.hh"
#include "Dacc.hh"
#include "Hanning.hh"
#include "VoltWatcher.hh"
#endif

   inline float VoltWatcher::RMS()
   {
      TSeries* tVoltP = (_bufStat==ODD ? &tVolt_even : &tVolt_odd);
   
      double sum = *tVoltP * *tVoltP;
      double rms = sqrt(sum/n);
   
      return rms;
   }

   fComplex VoltWatcher::GetCoef(const float freq) const
   {
      fComplex C(0,0);						// Holds the integral sum
   
      const double arg=2.0*3.14159265359*freq*dt;	// (ROOT HATES THIS)
      fComplex dP(cos(arg),-sin(arg));
      fComplex P(1);
   
      fComplex dummy(S[0]);			// Integrate S(t) * exp(i*omega*t)
      dummy /= 2;					//by trapezoid rule
      C += dummy;
      P *= dP;
   
      for(u_long j=1; j<n-1; j++)
      {
         dummy = S[j];
         dummy *= P;
         C += dummy;
         P *= dP;
      }
   
      dummy = S[n-1];	
      dummy *= P;
      dummy /= 2;
      C += dummy;
   
      C /= n;
      C *= 2;
      return C;
   }

   float VoltWatcher::ApproxMaxF(const float freq, const bool YNPrint) const
   {
      const float WIDTH = 0.05;
      float f1 = freq - WIDTH;
      float f2 = freq;
      float f3 = freq + WIDTH;
   
      fComplex C1(GetCoef(f1));
      fComplex C2(GetCoef(f2));
      fComplex C3(GetCoef(f3));
   
      float s1 = C1.Mag();
      float s2 = C2.Mag();
      float s3 = C3.Mag();
   
      float F = (f1-f2)/(f2-f3);
      float a = (s1-s2-(s2-s3)*F)/(f1*f1-f2*f2-(f2*f2-f3*f3)*F);
      float b = (s1-s2-a*(f1*f1-f2*f2))/(f1-f2);
      float h = -b/(2*a);
   
   #ifdef __CINT__
   if (YNPrint!=0) {
   fComplex CMax(GetCoef(h));
   float smax = CMax.Mag();
   cout << "Max Amplitude ~  " << smax << "\n";
   }
   #endif
   
      return h;
   }

   float VoltWatcher::Harmonics(const float freq)
   {	
      double nyquist = 1/(2*dt);
   
      fComplex C1(GetCoef(freq));
      float phi_1 = C1.Arg();
      float A_1 = C1.Mag();
      if(_VWrite) _VWrite->setData(_ID, v_A1, A_1*sqrt(1.5));
   // Hanning window reduces amplitudes by sqrt(1.5)
   
      fComplex C(0,0);
      double thd=0;
   
      for(int harm=2; harm*freq < nyquist; harm++)
      {
         C = GetCoef(harm*freq);
         float A_h = C.Mag();			// % of fundamental amplitude
         if(_VWrite) _VWrite->setData(_ID, v_HARM+2*harm-4, (A_h/A_1*100));
      
         thd += (A_h*A_h);
      
         float phase = C.Arg() - harm*phi_1;
         phase *= 180/3.14159265359;
         while(phase >= 360) {phase -= 360;}
         while(phase < 0)  {phase += 360;}
         if(_VWrite) _VWrite->setData(_ID, v_HARM+2*harm-3, phase);
      }
   
      thd = sqrt(thd)/A_1*100;
      return thd;
   }

#endif
