/* file LineTable.h */


#ifndef LineTable_HH
#define LineTable_HH

//#include "DatEnv.hh"
//#include "MonServer.hh"
//#include "OperStateCondList.hh"
//#include "Trend.hh"
#include "TSeries.hh"
#include "wavearray.hh"

namespace html {
    class document;
    class text;
}

#include <list>
#include <map>

struct alarmEntry{  
    size_t          fid;     // fid
    float           snr;     // holds SNR to send alarm 
    bool            b;       // if  alarm is on or off 
    bool            c;       // if  alarm has been changed(true)
};

struct lineEntry {
    float               frequency;
    float               amplitude;
    float               SNR;
    float               width;
    size_t              event;
    bool                al_m;
    int                 index;  // channel index for multichannel operation
};


class LineTable : public wavearray<double>{
    
public:
    
    LineTable(double=1.,size_t=1,double=2.);     // Constructor
    ~LineTable();                                // Destructor
    
    void lineFinder(TSeries &, float, float);
    void lineFinder(wavearray<double> &, float, float);
    void DumpHTML(std::vector<char*>&, char*, int=1);
    void update(std::vector<LineFilter*>&, std::vector<int>&);
    void update(std::vector<alarmEntry *>);
    inline void setStride(double x){ strideTime = x; }
    inline void setLiveTime(double x){ liveTime = x; }
    
    std::list<lineEntry>   lineTable;
    std::list<lineEntry>   lineList; 
    std::list<lineEntry>   lmonList; 
    
    char * htmlName;
    size_t nSub;           // number of substrides
    double limSNR;         // limit on SNR
    double fftRes;         // fft resolution
    double currentTime;    // current GPS time stamp
    double startTime;      // start GPS time stamp
    double liveTime;       // live time
    double strideTime;     // stride
    
    //  TrigPar   mDict;
};


#endif     //  LINETABLE_HH












