#ifndef TRIGGERFILES_HH
#define TRIGGERFILES_HH

#include <iostream>
#include <vector>
#include <ext/hash_map>
using __gnu_cxx::hash_map;
#include "Time.hh"

class TriggerFiles {
  public:
    // default constructor
    TriggerFiles(void);
    
    // constructor: specify a path and start time for the trigger files
    TriggerFiles(const std::string& path, const unsigned long t0=0);

    // destructor
    virtual ~TriggerFiles();

    // dump all the files to the specified output stream
    std::ostream& Dump(std::ostream& out) const;

    // get the start time for files
    const unsigned long getStartTime(void) const;

    // set an end time for testing
    void setEndTime(const unsigned long& te);

    // get an end time for testing
    const unsigned long getEndTime(void) const;

    // return a valid pointer to a zero terminated path string or null
    const char* getPath(void) const;
    
    // update for files newer than t0 and return only new files
    std::vector< std::string > newFiles(void);

    // flush old files and update t0
    void flushOld(const unsigned long t0);

  private:
    // the information about the files we want to store
    typedef struct
    {
      std::string       name;
      unsigned long     length;
    }
    triggerfile_t;

    // a hash map to store the trigger file information
    typedef hash_map< unsigned long, triggerfile_t > filemap_t;

    // earliest time we care about
    unsigned long       mT0;

    // latest time we care about (for testing)
    unsigned long       mTe;

    // hash map of the files we know about
    filemap_t           mFiles;

    // path to the trigger files
    std::string         mPath;
};

#ifndef __CINT__
inline const unsigned long
TriggerFiles::getStartTime(void) const
{
  return mT0;
}

inline const unsigned long
TriggerFiles::getEndTime(void) const
{
  return mTe;
}

inline const char*
TriggerFiles::getPath(void) const
{
  return mPath.c_str();
}
#endif // __CINT__

#endif // TRIGGERFILES_HH
